/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/

const work_dir = process.cwd();
const route_dir = "/app/routes";
var fs = require('fs');
var express = require('express');
var URL = require('url');
var logger = require('winston');
var async = require('async');
var fscan = require('./../common/fscan');
const config = require(process.cwd() + '/config/config');
//var passport = require('passport');


var loadRouter = function (app, nylon_path, prefix, wd, rd, routes, callback) {
    async.each(routes, function (route, next) {
        try {
            var rname = route.replace(".routes.js", "");
            rname = rname.replace(wd, "");
            rname = rname.replace(rd, "");
            var router = express.Router();
            //router.ws=app.ws;
           // router.authenticate=app.nylon.authenticate
            require(route)(router, nylon_path);
            if (prefix == "/api") {
                app.use(prefix + rname, router);
            } else {
                app.use(prefix + rname, router);
            }

            logger.info("nylon start route ::  " + prefix + rname + " >> " + rd + rname + ".routes.js");
            next();
        }
        catch (err) {
            logger.error(err);
            next();
        }
    }, function (err) {
        callback(err, app);
    });





}

module.exports = function (app) {
    // app = require('./../routes/oauth.routes')(app, nylon_path);
    //app = require('./../routes/pusher.routes')(app);
    var db = app.nylon.r;
    var nylon_path = app.nylon.nylon_path;


    //Object.assign({}, config.database,
    //   { db: dbId, user: config.appId, password: config.appKey })


    app.use(function (req, res, next) {

        //   req.r = app.nylon.req.r;
        //   console.log(app.nylon.req.r)
        //req.logger = app.nylon.logger;

        Object.assign(req, app.nylon.req);
        Object.assign(res, app.nylon.res);
      //    console.log(req.r);

        req.r._Term.prototype.pager = function () {
            // var url =req.baseUrl;// URL.parse(req.url, true).pathname;
             //console.log(req);
             var limit = 50;
             var page = 1;
 
             if (req.query._limit) {
                 limit = parseInt(req.query._limit);
                 page = parseInt(req.query._page);
             }
             else if (req.body._limit) {
                 limit = parseInt(req.body._limit);
                 page = parseInt(req.body._page);
             }
             else if (req.headers._limit) {
                 limit = parseInt(req.headers._limit);
                 page = parseInt(req.headers._page);
             }
             var skip = (limit * (page - 1));
             var rowEnd = skip + limit;
             var rowStart = skip + 1;
 
             return this.do(function (data) {
                 return r.branch(
                     data.typeOf().eq('ARRAY'),
                     {
                         _totalCount: data.count(),
                         _totalPage: r.ceil(data.count().div(limit)),
                         _pageLimit: limit,
                         _currentPage: page,
                         _nextPage: r.branch(r.lt(data.count(), rowEnd).or(r.eq(data.count(), rowEnd)), page, page + 1),
                         _rowStart: rowStart,
                         _rowEnd: r.branch(r.lt(data.count(), rowEnd), data.count(), rowEnd),
                         _option: 'pagination',
                         data: data.skip(skip).limit(limit)
                     }
                     ,
                     data
                 )
             })
         };

        
        res.header("Access-Control-Allow-Origin", "*");
        res.header("Access-Control-Allow-Methods", "GET, POST, OPTIONS, PUT, DELETE");
        res.header("Access-Control-Allow-Headers", "Origin, X-Custom-Header, X-Requested-With, Content-Type, Accept, X-APP-ID, X-APP-KEY,X-CLIENT-ID,X-CLIENT-KEY, Authorization, token");

        
        next();
    });

    //  fscan.scan(nylon_path + "/lib/app/routes", ".routes.js", true, function (err, routes_root) {
    //     loadRouter(app, nylon_path, "", nylon_path, "/lib/app/routes", routes_root, function (err, app) {

    fscan.scan(work_dir + route_dir, ".routes.js", true, function (err, routes) {
        loadRouter(app, nylon_path, "/api", work_dir, route_dir, routes, function (err, app) {
            //callback(app);
            
            // app.use(express.static(work_dir + '/public'));
            // app.use('/nylon', express.static(nylon_path + '/lib/public'));
            // app.use(function (req, res, next) {
            //     var ref = req.headers["referer"];
            //     console.log(ref);
            //     var url = URL.parse(req.url, true).pathname;
            //     if (url.indexOf('api') < 0 && url.indexOf('.') < 0) {
            //         res.status(200);
            //         res.sendFile(work_dir + '/public/index.html', 200);
            //     } else {
            //         if (ref) {
            //             next();
            //         } else {
            //             res.sendFile(work_dir + '/public/index.html', 200);
            //         }

            //     }
            // });
        });
    });

    //  });
    // });


}