/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;

public class JRClonePool {
    public static final String EXCEPTION_MESSAGE_KEY_PARAMETER_NOT_FOUND = "fill.clone.pool.cannot.release.clone";
    private final JRFillCloneable original;
    private final LinkedList<JRFillCloneable> availableClones;
    private final boolean trackLockedClones;
    private final Set<JRFillCloneable> lockedClones;

    public JRClonePool(JRFillCloneable original, boolean trackLockedClones, boolean useOriginal) {
        this.original = original;
        this.availableClones = new LinkedList();
        this.trackLockedClones = trackLockedClones;
        this.lockedClones = trackLockedClones ? new HashSet<JRFillCloneable>() : null;
        if (useOriginal) {
            this.availableClones.add(original);
        }
    }

    public Object getClone() {
        JRFillCloneable clone;
        if (this.availableClones.isEmpty()) {
            JRFillCloneFactory factory = new JRFillCloneFactory();
            clone = this.original.createClone(factory);
        } else {
            clone = this.availableClones.removeFirst();
        }
        if (this.trackLockedClones) {
            this.lockedClones.add(clone);
        }
        return clone;
    }

    public void releaseClone(Object clone) {
        if (this.trackLockedClones && !this.lockedClones.remove(clone)) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_PARAMETER_NOT_FOUND, (Object[])null);
        }
        this.availableClones.addLast((JRFillCloneable)clone);
    }
}

