/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.nio.charset.Charset;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

final class NIOAcceptPacket
extends NIOPacket {
    protected int version;
    protected int options;
    protected int sduSize;
    protected int tduSize;
    protected int myHWByteOrder;
    protected int flag0;
    protected int flag1;
    String connectData;

    NIOAcceptPacket(NIOHeader nIOHeader, SessionAtts sessionAtts) throws IOException {
        super(nIOHeader, sessionAtts);
    }

    @Override
    void readPayloadBuffer() throws IOException, NetException {
        short s2 = 0;
        short s3 = 0;
        this.version = this.session.payloadBuffer.getShort();
        this.options = this.session.payloadBuffer.getShort();
        this.sduSize = this.session.payloadBuffer.getShort() & 0xFFFF;
        this.tduSize = this.session.payloadBuffer.getShort() & 0xFFFF;
        this.myHWByteOrder = this.session.payloadBuffer.getShort();
        short s4 = this.session.payloadBuffer.getShort();
        short s5 = this.session.payloadBuffer.getShort();
        this.flag0 = this.session.payloadBuffer.get();
        this.flag1 = this.session.payloadBuffer.get();
        this.session.timeout = this.session.payloadBuffer.getShort();
        this.session.tick = this.session.payloadBuffer.getShort();
        s2 = this.session.payloadBuffer.getShort();
        s3 = this.session.payloadBuffer.getShort();
        this.session.timeout -= this.session.tick;
        this.session.timeout *= 10;
        if (s2 > 0) {
            this.session.reconnectAddress = new byte[s2];
            this.session.payloadBuffer.position(s3 - 8);
            this.session.payloadBuffer.get(this.session.reconnectAddress, 0, s2);
        }
        if (this.version >= 315) {
            this.sduSize = this.session.payloadBuffer.getInt(24);
            this.tduSize = this.session.payloadBuffer.getInt(28);
            this.session.isLargeSDU = true;
            this.session.dataChannel.setLargeSDU(true);
            this.session.markerPacket.setLargeSDU(true);
        }
        if (this.session.timeout > 0) {
            int n2 = s4 + s5 - 8;
            this.session.poolEnabled = true;
            this.session.sessionId = new byte[16];
            this.session.payloadBuffer.position(n2);
            this.session.payloadBuffer.get(this.session.sessionId, 0, 16);
            this.session.dataChannel.setPoolEnabled(true);
            this.session.timestampLastIO = System.currentTimeMillis();
        }
        if (s4 > 0) {
            byte[] byArray = null;
            if (this.session.payloadBuffer.hasRemaining()) {
                byArray = new byte[s4];
                this.session.payloadBuffer.position(s5);
                this.session.payloadBuffer.get(byArray);
            } else {
                byArray = this.session.dataChannel.readPayloadDataFromSocketChannel(s4);
            }
            this.connectData = new String(byArray, Charset.forName("US-ASCII"));
        }
        if (this.tduSize < this.sduSize) {
            this.session.setNegotiatedSDUAndTDU(this.tduSize, this.tduSize);
        } else {
            this.session.setNegotiatedSDUAndTDU(this.sduSize, this.tduSize);
        }
        this.session.setNegotiatedOptions(this.options);
    }
}

