/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import com.lowagie.toolbox.swing.PdfInformationPanel;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class Burst
extends AbstractTool {
    public Burst() {
        FileArgument fileArgument = new FileArgument(this, "srcfile", "The file you want to split", false, new PdfFilter());
        fileArgument.setLabel(new PdfInformationPanel());
        this.arguments.add(fileArgument);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Burst", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Burst OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            File file2 = file.getParentFile();
            String string = file.getName();
            string = string.substring(0, string.lastIndexOf(46));
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            int n = pdfReader.getNumberOfPages();
            int n2 = 1 + n / 10;
            System.out.println("There are " + n + " pages in the original file.");
            for (int i = 0; i < n; ++i) {
                int n3 = i + 1;
                String string2 = String.valueOf(n3);
                while (string2.length() < n2) {
                    string2 = "0" + string2;
                }
                string2 = "_" + string2 + ".pdf";
                Document document = new Document(pdfReader.getPageSizeWithRotation(n3));
                PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(new File(file2, string + string2)));
                document.open();
                PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n3);
                int n4 = pdfReader.getPageRotation(n3);
                if (n4 == 90 || n4 == 270) {
                    pdfContentByte.addTemplate(pdfImportedPage, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, pdfReader.getPageSizeWithRotation(n3).getHeight());
                } else {
                    pdfContentByte.addTemplate(pdfImportedPage, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                }
                document.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueHasChanged(AbstractArgument abstractArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Burst burst = new Burst();
        if (stringArray.length < 1) {
            System.err.println(burst.getUsage());
        }
        burst.setMainArguments(stringArray);
        burst.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is more than one destfile.");
    }

    static {
        Burst.addVersion("$Id: Burst.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

