/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/

const fs=require('fs');
const cluster = require('cluster');
var logger = require('winston');
var chokidar = require('chokidar');
//var watchers = [];
const addWatcher=function (path){
    var op={
        persistent: true,
          //ignored: '*.txt',
          ignoreInitial: false,
          followSymlinks: true,
          cwd: '.',
          disableGlobbing: true,
          usePolling: true,
          interval: 100,
          binaryInterval: 300,
          alwaysStat: false,
          depth: 99,
          awaitWriteFinish: {
            stabilityThreshold: 2000,
            pollInterval: 100
          },
        
          ignorePermissionErrors: false,
          atomic: true // or a custom 'atomicity delay', in milliseconds (default 100)
    };

    var evn_win=process.env.NYLON_WATCH || 'LINUX';
    if(evn_win!="LINUX"){
        op.disableGlobbing=false; 
        op.usePolling=false;  
    }

    var watcher=chokidar.watch(path, op);
    watcher.ready=false;
    watcher.on("ready",function(){
        watcher.ready=true;
    });
    watcher.on('all', (eventType, filename) => {
        if(watcher.ready){
            logger.info(filename + " is changed  try to restart server ..");
            //Object.keys(cluster.workers).forEach((id) => {
              //  cluster.workers[id].process.kill();
            //});
            process.exit(0);
        }
    });
    //watchers.push(watcher);

    // fs.readdir(path, function(err, files) { 
    //      files.forEach(function(filename) {
    //             fs.stat(path +"/"+ filename, function(err, stats) {
    //                 if (!err) {
    //                     if(stats.isDirectory()){
    //                         addWatcher(path+"/"+filename);
    //                     }
    //                 }
    //             });
    //     });
    // });
} 

exports.addWatcher=addWatcher;