/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/

process.env.NODE_ENV = process.env.NODE_ENV || 'development';
const cluster = require('cluster');
const http = require('http');
//const http2 = require('spdy');
const fs = require('fs');
const application = require('./server-app');
var logger = require('./server-logger');
const watcher = require('./server-watcher');
// const manifest = require('./../core/manifest');
const config = require(process.cwd() + '/config/config');
const work_dir = process.cwd();
logger = logger.logger;



exports.serve = function (nylon_path, port) {

    var nylon = {
        logger: logger,
        config: config,
        work_dir: work_dir,
        nylon_path: nylon_path,
        server_port: port,

        req: {

        },
        res: {

        }
    };

    if (cluster.isMaster) {

        cluster.fork();
        cluster.on('exit', (worker, code, signal) => {
            console.log("code::" + code);
            console.log("signal::" + signal);
            // if (code != 255) {
            cluster.fork();
            logger.info('worker ' + worker.process.pid + ' died');
            //}else{
            //  process.exit(0);
            // }

        });

        process.on('SIGINT', function () {
            for (worker in cluster.workers) {
                cluster.workers[worker].kill();
            }
            process.exit(0);
        });
        //  cluster.on('online', (worker) => {
        //console.log(process.cwd());
        watcher.addWatcher(process.cwd() + '/app');
        watcher.addWatcher(process.cwd() + '/config');
        // watcher.addWatcher(process.cwd() + '/ssl');
        watcher.addWatcher(nylon.nylon_path + '/java/libs');
        watcher.addWatcher(nylon.nylon_path + '/java/nylon-report/dist');
        watcher.addWatcher(nylon.nylon_path + '/java/nylon-utility/dist');
        watcher.addWatcher(nylon.nylon_path + '/lib');
        //   });


    } else {

        //  nylon.server_key = fs.readFileSync(nylon.work_dir + "/ssl/server.key");
        // nylon.server_cert = fs.readFileSync(nylon.work_dir + "/ssl/server.crt");

        // nylon.req.server_key=nylon.server_key;
        nylon.server_key = "1234560";
        var app = application(nylon);
        var server = null;


        /* var options = {
             key: nylon.server_key, //fs.readFileSync(work_dir + "/ssl/server.key"),
             cert: nylon.server_cert, // fs.readFileSync(work_dir + "/ssl/server.crt"),
             spdy: {
                 protocols: ['h2', 'spdy/3.1', 'spdy/3', 'spdy/2', 'http/1.1', 'http/1.0'],
                 plain: false,
                 'x-forwarded-for': true,
                 connection: {
                     windowSize: 1024 * 1024,
                     autoSpdy31: false
                 }
             }
         };*/


        //    server = http2.createServer(options, app);
        server = http.createServer(app);


        server.listen(nylon.server_port, function (error) {
            if (error) {
                logger.error(error);
            } else {
                logger.info('Nylon server listening on port ' + nylon.server_port + ' pid ' + process.pid);
            }
        });

        process.on('uncaughtException', function (err) {
            logger.error(err);
            process.exit(1);
        });
        module.exports = app;
    }
}