/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import net.sf.jasperreports.data.cache.ColumnValuesIterator;

class RunLengthIterator
implements ColumnValuesIterator {
    private final ColumnValuesIterator values;
    private final ColumnValuesIterator lengths;
    private int currentCount;
    private Object currentValue;

    public RunLengthIterator(ColumnValuesIterator values, ColumnValuesIterator lengths) {
        this.values = values;
        this.lengths = lengths;
        this.currentCount = 0;
        this.currentValue = null;
    }

    @Override
    public void moveFirst() {
        this.values.moveFirst();
        this.lengths.moveFirst();
        this.currentCount = 0;
        this.currentValue = null;
    }

    @Override
    public boolean next() {
        if (this.currentCount > 1) {
            --this.currentCount;
            return true;
        }
        if (!this.lengths.next()) {
            return false;
        }
        if (!this.values.next()) {
            throw new IllegalStateException();
        }
        this.currentCount = ((Number)this.lengths.get()).intValue();
        this.currentValue = this.values.get();
        return true;
    }

    @Override
    public Object get() {
        return this.currentValue;
    }
}

