/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/

//const work_dir = process.cwd();
const route_dir = "/app/routes";
var fs = require('fs');
var express = require('express');
var URL = require('url');
var logger = require('winston');
var async = require('async');
var fscan = require('./../common/fscan');
var prpl = require('prpl-server');


var loadRouter = function (app, prefix, wd, rd, routes, callback) {
    async.each(routes, function (route, next) {
        try {
            var rname = route.replace(".routes.js", "");
            rname = rname.replace(wd, "");
            rname = rname.replace(rd, "");
            var router = express.Router();
            require(route)(router);
            if (prefix == "/api") {
                app.use(prefix + rname, router);
            } else {
                app.use(prefix + rname, router);
            }

            logger.info("nylon start route ::  " + prefix + rname + " >> " + rd + rname + ".routes.js");
            next();
        }
        catch (err) {
            logger.error(err);
            next();
        }
    }, function (err) {
        callback(err, app);
    });





}

module.exports = function (app) {
    if (app.nylon.req.r) {
        //var req=app.nylon.req;
        // var r=app.nylon.req.r;

        app.nylon.req.r._Term.prototype.pager = function (req) {
            var r = req.r;
            var limit = 50;
            var page = 1;
            if (req.query._limit) {
                limit = parseInt(req.query._limit);
                page = parseInt(req.query._page);
            }
            else if (req.body._limit) {
                limit = parseInt(req.body._limit);
                page = parseInt(req.body._page);
            }
            else if (req.headers._limit) {
                limit = parseInt(req.headers._limit);
                page = parseInt(req.headers._page);
            }
            var skip = (limit * (page - 1));
            var rowEnd = skip + limit;
            var rowStart = skip + 1;

            return this.do(function (data) {
                //  var r=this;
                return r.branch(
                    data.typeOf().eq('ARRAY'),
                    {
                        _totalCount: data.count(),
                        _totalPage: r.ceil(data.count().div(limit)),
                        _pageLimit: limit,
                        _currentPage: page,
                        _nextPage: r.branch(r.lt(data.count(), rowEnd).or(r.eq(data.count(), rowEnd)), page, page + 1),
                        _rowStart: rowStart,
                        _rowEnd: r.branch(r.lt(data.count(), rowEnd), data.count(), rowEnd),
                        _option: 'pagination',
                        data: data.skip(skip).limit(limit)
                    }
                    ,
                    data
                )
            })
        };

    }



    app.use(function (req, res, next) {
        Object.assign(req, app.nylon.req);
        Object.assign(res, app.nylon.res);



        res.header("Access-Control-Allow-Origin", "*");
        res.header("Access-Control-Allow-Methods", "GET, POST, OPTIONS, PUT, DELETE");
        res.header("Access-Control-Allow-Headers", "Origin, X-Custom-Header, X-Requested-With, Content-Type, Accept, X-APP-ID, X-APP-KEY,X-CLIENT-ID,X-CLIENT-KEY, Authorization, token");
        next();
    });


    fscan.scan(app.nylon.work_dir + route_dir, ".routes.js", true, function (err, routes) {
        loadRouter(app, "/api", app.nylon.work_dir, route_dir, routes, function (err, app) {

            var evn=process.env.NYLON_WEB_TYPE || 'development';
            var evn_build=process.env.NYLON_WEB_BUILD_NAME || 'default';
            if(evn.toLowerCase()=="production"){
                app.get('/*', prpl.makeHandler('./public/build/'+evn_build, {
                    builds: [
                        { name: '.', browserCapabilities: ['es2015', 'push'] },
                        { name: '.' },
                    ],
                }));
            }else{
                app.get('/*', prpl.makeHandler('./public', {
                    builds: [
                        { name: '.', browserCapabilities: ['es2015', 'push'] },
                        { name: '.' },
                    ],
                }));
            }
            

        });
    });

}