/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SocketConnector;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.text.Format;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SocketFinder {
    private static final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private static final int minTimeoutForParallelConnections = 1500;
    private final Object socketFinderlock = new Object();
    private final Object parentThreadLock = new Object();
    private volatile Result result = Result.UNKNOWN;
    private int noOfSpawnedThreads = 0;
    private volatile int noOfThreadsThatNotified = 0;
    private volatile Socket selectedSocket = null;
    private volatile IOException selectedException = null;
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SocketFinder");
    private final String traceID;
    private static final int ipAddressLimit = 64;
    private final SQLServerConnection conn;

    SocketFinder(String string, SQLServerConnection sQLServerConnection) {
        this.traceID = "SocketFinder(" + string + ")";
        this.conn = sQLServerConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Socket findSocket(String string, int n, int n2, boolean bl) throws SQLServerException {
        assert (n2 != 0) : "The driver does not allow a time out of 0";
        try {
            Object[] objectArray;
            Object object;
            if (!bl) {
                return this.getDefaultSocket(string, n, n2);
            }
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            if (logger.isLoggable(Level.FINER)) {
                object = this.toString() + " Total no of InetAddresses: " + inetAddressArray.length + ". They are: ";
                for (InetAddress inetAddress : inetAddressArray) {
                    object = (String)object + inetAddress.toString() + ";";
                }
                logger.finer((String)object);
            }
            if (inetAddressArray.length > 64) {
                object = new MessageFormat(SQLServerException.getErrString("R_ipAddressLimitWithMultiSubnetFailover"));
                objectArray = new Object[]{Integer.toString(64)};
                String string2 = ((Format)object).format(objectArray);
                this.conn.terminate(6, string2);
            }
            if (Util.isIBM()) {
                n2 = Math.max(n2, 1500);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + "Using Java NIO with timeout:" + n2);
                }
                this.findSocketUsingJavaNIO(inetAddressArray, n, n2);
            } else {
                object = new LinkedList();
                objectArray = new LinkedList();
                for (InetAddress inetAddress : inetAddressArray) {
                    if (inetAddress instanceof Inet4Address) {
                        ((LinkedList)object).add((Inet4Address)inetAddress);
                        continue;
                    }
                    assert (inetAddress instanceof Inet6Address) : "Unexpected IP address " + inetAddress.toString();
                    objectArray.add((Inet6Address)inetAddress);
                }
                int n3 = !((AbstractCollection)object).isEmpty() && !objectArray.isEmpty() ? Math.max(n2 / 2, 1500) : Math.max(n2, 1500);
                if (!((AbstractCollection)object).isEmpty()) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.toString() + "Using Java NIO with timeout:" + n3);
                    }
                    this.findSocketUsingJavaNIO(((LinkedList)object).toArray(new InetAddress[0]), n, n3);
                }
                if (!this.result.equals((Object)Result.SUCCESS) && !objectArray.isEmpty()) {
                    if (objectArray.size() == 1) {
                        return this.getConnectedSocket((InetAddress)objectArray.get(0), n, n3);
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.toString() + "Using Threading with timeout:" + n3);
                    }
                    this.findSocketUsingThreading((LinkedList<Inet6Address>)objectArray, n, n3);
                }
            }
            if (this.result.equals((Object)Result.UNKNOWN)) {
                object = this.socketFinderlock;
                synchronized (object) {
                    if (this.result.equals((Object)Result.UNKNOWN)) {
                        this.result = Result.FAILURE;
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(this.toString() + " The parent thread updated the result to failure");
                        }
                    }
                }
            }
            if (this.result.equals((Object)Result.FAILURE)) {
                if (this.selectedException == null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.toString() + " There is no selectedException. The wait calls timed out before any connect call returned or timed out.");
                    }
                    object = SQLServerException.getErrString("R_connectionTimedOut");
                    this.selectedException = new IOException((String)object);
                }
                throw this.selectedException;
            }
        }
        catch (InterruptedException interruptedException) {
            this.close(this.selectedSocket);
            SQLServerException.ConvertConnectExceptionToSQLServerException(string, n, this.conn, interruptedException);
        }
        catch (IOException iOException) {
            this.close(this.selectedSocket);
            SQLServerException.ConvertConnectExceptionToSQLServerException(string, n, this.conn, iOException);
        }
        assert (this.result.equals((Object)Result.SUCCESS));
        assert (this.selectedSocket != null) : "Bug in code. Selected Socket cannot be null here.";
        return this.selectedSocket;
    }

    private void findSocketUsingJavaNIO(InetAddress[] inetAddressArray, int n, int n2) throws IOException {
        assert (n2 != 0) : "The timeout cannot be zero";
        assert (inetAddressArray.length != 0) : "Number of inetAddresses should not be zero in this function";
        Selector selector = null;
        LinkedList<SocketChannel> linkedList = new LinkedList<SocketChannel>();
        AbstractSelectableChannel abstractSelectableChannel = null;
        try {
            long l;
            selector = Selector.open();
            for (int i = 0; i < inetAddressArray.length; ++i) {
                SocketChannel socketChannel = SocketChannel.open();
                linkedList.add(socketChannel);
                socketChannel.configureBlocking(false);
                int n3 = 8;
                SelectionKey selectionKey = socketChannel.register(selector, n3);
                socketChannel.connect(new InetSocketAddress(inetAddressArray[i], n));
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer(this.toString() + " initiated connection to address: " + inetAddressArray[i] + ", portNumber: " + n);
            }
            long l2 = System.currentTimeMillis();
            long l3 = l2 + (long)n2;
            int n4 = inetAddressArray.length;
            while ((l = l3 - l2) > 0L && abstractSelectableChannel == null) {
                if (n4 <= 0) {
                    break;
                }
                int n5 = selector.select(l);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + " no of channels ready: " + n5);
                }
                if (n5 != 0) {
                    Set<SelectionKey> set = selector.selectedKeys();
                    Iterator<SelectionKey> iterator = set.iterator();
                    while (iterator.hasNext()) {
                        SelectionKey selectionKey = iterator.next();
                        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(this.toString() + " processing the channel :" + socketChannel);
                        }
                        boolean bl = false;
                        try {
                            bl = socketChannel.finishConnect();
                            assert (bl) : "finishConnect on channel:" + socketChannel + " cannot be false";
                            abstractSelectableChannel = socketChannel;
                            if (!logger.isLoggable(Level.FINER)) break;
                            logger.finer(this.toString() + " selected the channel :" + abstractSelectableChannel);
                            break;
                        }
                        catch (IOException iOException) {
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer(this.toString() + " the exception: " + iOException.getClass() + " with message: " + iOException.getMessage() + " occured while processing the channel: " + socketChannel);
                            }
                            this.updateSelectedException(iOException, this.toString());
                            socketChannel.close();
                            selectionKey.cancel();
                            iterator.remove();
                            --n4;
                        }
                    }
                }
                l2 = System.currentTimeMillis();
            }
        }
        catch (IOException iOException) {
            this.close((SocketChannel)abstractSelectableChannel);
            throw iOException;
        }
        finally {
            this.close(selector);
            for (SocketChannel socketChannel : linkedList) {
                if (socketChannel == abstractSelectableChannel) continue;
                this.close(socketChannel);
            }
        }
        if (abstractSelectableChannel != null) {
            abstractSelectableChannel.configureBlocking(true);
            this.selectedSocket = ((SocketChannel)abstractSelectableChannel).socket();
            this.result = Result.SUCCESS;
        }
    }

    private Socket getDefaultSocket(String string, int n, int n2) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        return this.getConnectedSocket(inetSocketAddress, n2);
    }

    private Socket getConnectedSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        return this.getConnectedSocket(inetSocketAddress, n2);
    }

    private Socket getConnectedSocket(InetSocketAddress inetSocketAddress, int n) throws IOException {
        assert (n != 0) : "timeout cannot be zero";
        if (inetSocketAddress.isUnresolved()) {
            throw new UnknownHostException();
        }
        this.selectedSocket = new Socket();
        this.selectedSocket.connect(inetSocketAddress, n);
        return this.selectedSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findSocketUsingThreading(LinkedList<Inet6Address> linkedList, int n, int n2) throws IOException, InterruptedException {
        assert (n2 != 0) : "The timeout cannot be zero";
        assert (!linkedList.isEmpty()) : "Number of inetAddresses should not be zero in this function";
        LinkedList<Socket> linkedList2 = new LinkedList<Socket>();
        LinkedList<SocketConnector> linkedList3 = new LinkedList<SocketConnector>();
        try {
            this.noOfSpawnedThreads = linkedList.size();
            for (InetAddress object : linkedList) {
                Socket socket = new Socket();
                linkedList2.add(socket);
                InetSocketAddress inetSocketAddress = new InetSocketAddress(object, n);
                SocketConnector socketConnector = new SocketConnector(socket, inetSocketAddress, n2, this);
                linkedList3.add(socketConnector);
            }
            Iterator iterator = this.parentThreadLock;
            synchronized (iterator) {
                for (SocketConnector socketConnector : linkedList3) {
                    threadPoolExecutor.execute(socketConnector);
                }
                long socket = System.currentTimeMillis();
                long l = socket + (long)n2;
                while (true) {
                    long l2 = l - socket;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.toString() + " TimeRemaining:" + l2 + "; Result:" + (Object)((Object)this.result) + "; Max. open thread count: " + threadPoolExecutor.getLargestPoolSize() + "; Current open thread count:" + threadPoolExecutor.getActiveCount());
                    }
                    if (l2 <= 0L || !this.result.equals((Object)Result.UNKNOWN)) break;
                    this.parentThreadLock.wait(l2);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.toString() + " The parent thread wokeup.");
                    }
                    socket = System.currentTimeMillis();
                }
            }
        }
        finally {
            for (Socket socket : linkedList2) {
                if (socket == this.selectedSocket) continue;
                this.close(socket);
            }
        }
    }

    Result getResult() {
        return this.result;
    }

    void close(Selector selector) {
        block4: {
            if (null != selector) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + ": Closing Selector");
                }
                try {
                    selector.close();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.FINE)) break block4;
                    logger.log(Level.FINE, this.toString() + ": Ignored the following error while closing Selector", iOException);
                }
            }
        }
    }

    void close(Socket socket) {
        block4: {
            if (null != socket) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + ": Closing TCP socket:" + socket);
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.FINE)) break block4;
                    logger.log(Level.FINE, this.toString() + ": Ignored the following error while closing socket", iOException);
                }
            }
        }
    }

    void close(SocketChannel socketChannel) {
        block4: {
            if (null != socketChannel) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + ": Closing TCP socket channel:" + socketChannel);
                }
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.FINE)) break block4;
                    logger.log(Level.FINE, this.toString() + "Ignored the following error while closing socketChannel", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateResult(Socket socket, IOException iOException, String string) {
        if (this.result.equals((Object)Result.UNKNOWN)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("The following child thread is waiting for socketFinderLock:" + string);
            }
            Object object = this.socketFinderlock;
            synchronized (object) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("The following child thread acquired socketFinderLock:" + string);
                }
                if (this.result.equals((Object)Result.UNKNOWN)) {
                    if (iOException == null && this.selectedSocket == null) {
                        this.selectedSocket = socket;
                        this.result = Result.SUCCESS;
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("The socket of the following thread has been chosen:" + string);
                        }
                    }
                    if (iOException != null) {
                        this.updateSelectedException(iOException, string);
                    }
                }
                ++this.noOfThreadsThatNotified;
                if (this.noOfThreadsThatNotified >= this.noOfSpawnedThreads && this.result.equals((Object)Result.UNKNOWN)) {
                    this.result = Result.FAILURE;
                }
                if (!this.result.equals((Object)Result.UNKNOWN)) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("The following child thread is waiting for parentThreadLock:" + string);
                    }
                    Object object2 = this.parentThreadLock;
                    synchronized (object2) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("The following child thread acquired parentThreadLock:" + string);
                        }
                        this.parentThreadLock.notify();
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("The following child thread released parentThreadLock and notified the parent thread:" + string);
                    }
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("The following child thread released socketFinderLock:" + string);
            }
        }
    }

    public void updateSelectedException(IOException iOException, String string) {
        boolean bl = false;
        if (this.selectedException == null) {
            this.selectedException = iOException;
            bl = true;
        } else if (!(iOException instanceof SocketTimeoutException) && this.selectedException instanceof SocketTimeoutException) {
            this.selectedException = iOException;
            bl = true;
        }
        if (bl && logger.isLoggable(Level.FINER)) {
            logger.finer("The selected exception is updated to the following: ExceptionType:" + iOException.getClass() + "; ExceptionMessage:" + iOException.getMessage() + "; by the following thread:" + string);
        }
    }

    public String toString() {
        return this.traceID;
    }

    static enum Result {
        UNKNOWN,
        SUCCESS,
        FAILURE;

    }
}

