/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/


var stream = require('stream');
const java = require('java');
const fs = require('fs');


module.exports = function (app) {
    var work_dir = app.nylon.work_dir;
    // app.use(function (req, res, next) {

    app.nylon.res.ireport = function (reportName, type, datas, parameters) {
        var self = this;
        var types = type.split("|");
        // console.log(types);
        type = types[0];
        var saved = false;
        if (types.length > 1) {
            saved = true;
        }
        var iReport = java.import("nylon.report.iReport");
        reportName = work_dir + "/app/reports/" + reportName;
        var rp = new iReport();
        if (parameters) {
            parameters["SUBREPORT_DIR"] = work_dir + "/app/reports/";
            //parameters["REPORT_LOCALE"]="th-TH";
            // parameters["REPORT_TIME_ZONE"]="asia/bangkok";

        } else {
            parameters = {
                "SUBREPORT_DIR": work_dir + "/app/reports/"
                //"REPORT_TIME_ZONE":"asia/bangkok",
                // "REPORT_LOCALE":"th-TH"
            };
        }
        // console.log(rp);
        var outname = "";
        if (parameters.OUTPUT_NAME != undefined && parameters.OUTPUT_NAME != "") {
            outname = parameters.OUTPUT_NAME;
        }


        rp.export(reportName, type, JSON.stringify(datas), JSON.stringify(parameters),
            function (err, buff) {
                if (err) {
                    self.send(err);
                } else {
                    var buffer = Buffer.from(buff, "hex");
                    self.responseFile(buffer, type, saved,outname);
                }

            }
        );
    }

    app.nylon.res.responseFile = function (buffer, type, saved,outname) {

        var self = this;
        var fname = (outname !="" ? outname :  self._guid()) + self._getFileExtension(type);
        //fname=encodeURI(fname);
        console.log(fname);
        
        if (saved) {
            var streamx = fs.createWriteStream(this.tmp_dir + fname);
            streamx.end(buffer);

            self.send(fname)
        } else {

            fname=encodeURI(fname);



            //stream.once('open', function(fd) {
            //  stream.write("My first row\n");
            //  stream.write("My second row\n");
            // stream.end();
            // });
            var bufferStream = new stream.PassThrough();
            bufferStream.end(buffer);
            this.setHeader('Content-Length', buffer.length);

            if (type == "pdf") {
                this.setHeader('Content-Type', 'application/pdf');
                this.setHeader('Content-Disposition', 'inline; filename=' + fname);
            } else if (type == 'excel') {
                this.setHeader('Content-Type', 'application/octet-stream');
                this.setHeader('Content-Disposition', 'attachment; filename=' + fname);
            } else if (type == 'word') {
                this.setHeader('Content-Type', 'application/octet-stream');
                this.setHeader('Content-Disposition', 'attachment; filename=' + fname);
            }
            else if (type == 'csv') {
                this.setHeader('Content-Type', 'application/octet-stream');
                this.setHeader('Content-Disposition', 'attachment; filename=' + fname);

            } else if (type == 'html') {
                this.setHeader('Content-Type', 'text/html');
                // this.setHeader('Content-Disposition', 'attachment; filename='+fname+'.csv');

            } else if (type == 'xml') {
                this.setHeader('Content-Type', 'application/octet-stream');
                this.setHeader('Content-Disposition', 'attachment; filename=' + fname);

            }
            else {
                this.setHeader('Content-Type', 'application/pdf');
                this.setHeader('Content-Disposition', 'attachment; filename=' + fname);
            }
            bufferStream.pipe(self);
        }
    }

    app.nylon.res._getFileExtension = function (type) {
        if (type == "pdf") {
            return ".pdf";
        } else if (type == 'excel') {
            return ".xlsx";
        } else if (type == 'word') {
            return ".docx";
        }
        else if (type == 'csv') {
            return ".csv";

        } else if (type == 'html') {
            return ".html";

        } else if (type == 'xml') {
            ;
            return ".xml";
        }
        else {
            return ".pdf";
        }
    }

    app.nylon.res._guid = function () {
        function s4() {
            return Math.floor((1 + Math.random()) * 0x10000)
                .toString(16)
                .substring(1);
        }
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
            s4() + '-' + s4() + s4() + s4();
    }

    //  next();

    // });



}