/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.MessageProvider;

public class ResourceBundleMessageProvider
implements MessageProvider {
    private final String baseName;
    private final HashMap<Locale, ResourceBundle> bundles = new HashMap();
    private final ClassLoader classLoader;

    public ResourceBundleMessageProvider(String baseName) {
        this(baseName, null);
    }

    public ResourceBundleMessageProvider(String baseName, ClassLoader classLoader) {
        this.baseName = baseName;
        this.classLoader = classLoader;
    }

    @Override
    public String getMessage(String code, Object[] args, Locale locale) {
        String pattern = this.getMessage(code, locale);
        return MessageFormat.format(pattern, args);
    }

    public String getMessage(String code, Locale locale) {
        ResourceBundle bundle = this.bundles.get(locale);
        if (bundle == null) {
            bundle = JRResourcesUtil.loadResourceBundle(this.baseName, locale, this.classLoader);
            this.bundles.put(locale, bundle);
        }
        return bundle.getString(code);
    }
}

