/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/

var java = require('java');
//var logger = require('winston');
var async = require('async');
const cluster = require('cluster');
//const config = require(process.cwd() + '/config/config');

var jdbc;
module.exports = function (app) {
    var config = app.nylon.config;
    var logger = app.nylon.logger;
    var jdbc_function = {
        query: function (driver, sql, parameters, callback) {

            if (jdbc == undefined) {
                console.log("jdbc first time");

                //var JDBCConnect = java.import("nylon.data.JDBCConnect");
                java.newInstancePromise("nylon.data.JDBCConnect")
                    .then(function (jdbc) {
                       // jdbc = new JDBCConnect();
                        if (config.jdbc) {
                            async.each(config.jdbc, function (conn, next) {
                                logger.info("JDBCConnect :: " + conn.name);
                                try {
                                    jdbc.addConnection(conn.name, conn.driver, conn.url, conn.user, conn.password
                                        , function (err, data) {
                                            console.log(data);
                                            next();
                                        }
                                    );
                                } catch (error) {
                                    next();
                                }
                            }, function (err) {
                                jdbc.query(driver, sql, parameters, function (err, data) {
                                    callback(err, data);
                                });
                            });
                        } else {
                            callback({ error: "plase check jdbc config" }, {});
                        }
                    }).catch(function (err) {
                        console.log(err);
                        Object.keys(cluster.workers).forEach((id) => {
                            cluster.workers[id].process.kill();
                        });
                    });





            } else {
                jdbc.query(driver, sql, parameters, function (err, data) {
                    callback(err, data);
                });
            }
        }
    }

    //app.use(function (req, res, next) {

    //    req.jdbc = jdbc_function;
    //   next();

    //});

    app.nylon.req.jdbc = jdbc_function;



}