/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ParseAnonymousUtils;
import com.parse.ParseCurrentUserController;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseObjectStore;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;
import com.parse.TaskQueue;
import java.util.Arrays;
import java.util.Map;

class CachedCurrentUserController
implements ParseCurrentUserController {
    private final Object mutex = new Object();
    private final TaskQueue taskQueue = new TaskQueue();
    private final ParseObjectStore<ParseUser> store;
    ParseUser currentUser;
    boolean currentUserMatchesDisk = false;

    public CachedCurrentUserController(ParseObjectStore<ParseUser> store) {
        this.store = store;
    }

    @Override
    public Task<Void> setAsync(final ParseUser user) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Task<Void> then(Task<Void> task) throws Exception {
                        ParseUser oldCurrentUser;
                        Object object = CachedCurrentUserController.this.mutex;
                        synchronized (object) {
                            oldCurrentUser = CachedCurrentUserController.this.currentUser;
                        }
                        if (oldCurrentUser != null && oldCurrentUser != user) {
                            return oldCurrentUser.logOutAsync(false).continueWith((Continuation)new Continuation<Void, Void>(){

                                public Void then(Task<Void> task) throws Exception {
                                    return null;
                                }
                            });
                        }
                        return task;
                    }
                }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        user.setIsCurrentUser(true);
                        return user.synchronizeAllAuthDataAsync();
                    }
                }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        return CachedCurrentUserController.this.store.setAsync(user).continueWith((Continuation)new Continuation<Void, Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public Void then(Task<Void> task) throws Exception {
                                Object object = CachedCurrentUserController.this.mutex;
                                synchronized (object) {
                                    CachedCurrentUserController.this.currentUserMatchesDisk = !task.isFaulted();
                                    CachedCurrentUserController.this.currentUser = user;
                                }
                                return null;
                            }
                        });
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task<Void> setIfNeededAsync(ParseUser user) {
        Object object = this.mutex;
        synchronized (object) {
            if (!user.isCurrentUser() || this.currentUserMatchesDisk) {
                return Task.forResult(null);
            }
        }
        return this.setAsync(user);
    }

    @Override
    public Task<ParseUser> getAsync() {
        return this.getAsync(ParseUser.isAutomaticUserEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task<Boolean> existsAsync() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.currentUser != null) {
                return Task.forResult((Object)true);
            }
        }
        return this.taskQueue.enqueue(new Continuation<Void, Task<Boolean>>(){

            public Task<Boolean> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Boolean>>(){

                    public Task<Boolean> then(Task<Void> task) throws Exception {
                        return CachedCurrentUserController.this.store.existsAsync();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrent(ParseUser user) {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentUser == user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFromMemory() {
        Object object = this.mutex;
        synchronized (object) {
            this.currentUser = null;
            this.currentUserMatchesDisk = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFromDisk() {
        Object object = this.mutex;
        synchronized (object) {
            this.currentUser = null;
            this.currentUserMatchesDisk = false;
        }
        try {
            ParseTaskUtils.wait(this.store.deleteAsync());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public Task<String> getCurrentSessionTokenAsync() {
        return this.getAsync(false).onSuccess((Continuation)new Continuation<ParseUser, String>(){

            public String then(Task<ParseUser> task) throws Exception {
                ParseUser user = (ParseUser)task.getResult();
                return user != null ? user.getSessionToken() : null;
            }
        });
    }

    @Override
    public Task<Void> logOutAsync() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                final Task<ParseUser> userTask = CachedCurrentUserController.this.getAsync(false);
                return Task.whenAll(Arrays.asList(userTask, toAwait)).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        Task logOutTask = userTask.onSuccessTask((Continuation)new Continuation<ParseUser, Task<Void>>(){

                            public Task<Void> then(Task<ParseUser> task) throws Exception {
                                ParseUser user = (ParseUser)task.getResult();
                                if (user == null) {
                                    return task.cast();
                                }
                                return user.logOutAsync();
                            }
                        });
                        Task diskTask = CachedCurrentUserController.this.store.deleteAsync().continueWith((Continuation)new Continuation<Void, Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public Void then(Task<Void> task) throws Exception {
                                boolean deleted = !task.isFaulted();
                                Object object = CachedCurrentUserController.this.mutex;
                                synchronized (object) {
                                    CachedCurrentUserController.this.currentUserMatchesDisk = deleted;
                                    CachedCurrentUserController.this.currentUser = null;
                                }
                                return null;
                            }
                        });
                        return Task.whenAll(Arrays.asList(logOutTask, diskTask));
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task<ParseUser> getAsync(final boolean shouldAutoCreateUser) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.currentUser != null) {
                return Task.forResult((Object)this.currentUser);
            }
        }
        return this.taskQueue.enqueue(new Continuation<Void, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<ParseUser>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Task<ParseUser> then(Task<Void> ignored) throws Exception {
                        boolean matchesDisk;
                        ParseUser current;
                        Object object = CachedCurrentUserController.this.mutex;
                        synchronized (object) {
                            current = CachedCurrentUserController.this.currentUser;
                            matchesDisk = CachedCurrentUserController.this.currentUserMatchesDisk;
                        }
                        if (current != null) {
                            return Task.forResult((Object)current);
                        }
                        if (matchesDisk) {
                            if (shouldAutoCreateUser) {
                                return Task.forResult((Object)CachedCurrentUserController.this.lazyLogIn());
                            }
                            return null;
                        }
                        return CachedCurrentUserController.this.store.getAsync().continueWith((Continuation)new Continuation<ParseUser, ParseUser>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public ParseUser then(Task<ParseUser> task) throws Exception {
                                ParseUser current = (ParseUser)task.getResult();
                                boolean matchesDisk = !task.isFaulted();
                                Object object = CachedCurrentUserController.this.mutex;
                                synchronized (object) {
                                    CachedCurrentUserController.this.currentUser = current;
                                    CachedCurrentUserController.this.currentUserMatchesDisk = matchesDisk;
                                }
                                if (current != null) {
                                    object = current.mutex;
                                    synchronized (object) {
                                        current.setIsCurrentUser(true);
                                    }
                                    return current;
                                }
                                if (shouldAutoCreateUser) {
                                    return CachedCurrentUserController.this.lazyLogIn();
                                }
                                return null;
                            }
                        });
                    }
                });
            }
        });
    }

    private ParseUser lazyLogIn() {
        Map<String, String> authData = ParseAnonymousUtils.getAuthData();
        return this.lazyLogIn("anonymous", authData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParseUser lazyLogIn(String authType, Map<String, String> authData) {
        ParseUser user = ParseObject.create(ParseUser.class);
        Object object = user.mutex;
        synchronized (object) {
            user.setIsCurrentUser(true);
            user.putAuthData(authType, authData);
        }
        object = this.mutex;
        synchronized (object) {
            this.currentUserMatchesDisk = false;
            this.currentUser = user;
        }
        return user;
    }
}

