/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import bolts.Capture;
import bolts.Task;
import bolts.TaskCompletionSource;
import com.parse.ParseException;
import com.parse.ParseExecutors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class LocationNotifier {
    private static Location fakeLocation = null;

    LocationNotifier() {
    }

    static Task<Location> getCurrentLocationAsync(Context context, long timeout, Criteria criteria) {
        final TaskCompletionSource tcs = new TaskCompletionSource();
        final Capture timeoutFuture = new Capture();
        final LocationManager manager = (LocationManager)context.getSystemService("location");
        final LocationListener listener = new LocationListener(){

            public void onLocationChanged(Location location) {
                if (location == null) {
                    return;
                }
                ((ScheduledFuture)timeoutFuture.get()).cancel(true);
                tcs.trySetResult((Object)location);
                manager.removeUpdates((LocationListener)this);
            }

            public void onProviderDisabled(String provider) {
            }

            public void onProviderEnabled(String provider) {
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }
        };
        timeoutFuture.set(ParseExecutors.scheduled().schedule(new Runnable(){

            @Override
            public void run() {
                tcs.trySetError((Exception)new ParseException(124, "Location fetch timed out."));
                manager.removeUpdates(listener);
            }
        }, timeout, TimeUnit.MILLISECONDS));
        String provider = manager.getBestProvider(criteria, true);
        if (provider != null) {
            manager.requestLocationUpdates(provider, 0L, 0.0f, listener);
        }
        if (fakeLocation != null) {
            listener.onLocationChanged(fakeLocation);
        }
        return tcs.getTask();
    }

    static void setFakeLocation(Location location) {
        fakeLocation = location;
    }
}

