/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ParseDecoder;
import com.parse.ParseHttpClient;
import com.parse.ParseObject;
import com.parse.ParseObjectCoder;
import com.parse.ParseRESTSessionCommand;
import com.parse.ParseSessionController;
import org.json.JSONObject;

class NetworkSessionController
implements ParseSessionController {
    private final ParseHttpClient client;
    private final ParseObjectCoder coder;

    public NetworkSessionController(ParseHttpClient client) {
        this.client = client;
        this.coder = ParseObjectCoder.get();
    }

    @Override
    public Task<ParseObject.State> getSessionAsync(String sessionToken) {
        ParseRESTSessionCommand command = ParseRESTSessionCommand.getCurrentSessionCommand(sessionToken);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, ParseObject.State>(){

            public ParseObject.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return ((ParseObject.State.Builder)NetworkSessionController.this.coder.decode(new ParseObject.State.Builder("_Session"), result, ParseDecoder.get()).isComplete(true)).build();
            }
        });
    }

    @Override
    public Task<Void> revokeAsync(String sessionToken) {
        return ParseRESTSessionCommand.revoke(sessionToken).executeAsync(this.client).makeVoid();
    }

    @Override
    public Task<ParseObject.State> upgradeToRevocable(String sessionToken) {
        ParseRESTSessionCommand command = ParseRESTSessionCommand.upgradeToRevocableSessionCommand(sessionToken);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, ParseObject.State>(){

            public ParseObject.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return ((ParseObject.State.Builder)NetworkSessionController.this.coder.decode(new ParseObject.State.Builder("_Session"), result, ParseDecoder.get()).isComplete(true)).build();
            }
        });
    }
}

