/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ParseDecoder;
import com.parse.ParseHttpClient;
import com.parse.ParseObject;
import com.parse.ParseObjectCoder;
import com.parse.ParseOperationSet;
import com.parse.ParseRESTUserCommand;
import com.parse.ParseUser;
import com.parse.ParseUserController;
import com.parse.PointerEncoder;
import java.util.Map;
import org.json.JSONObject;

class NetworkUserController
implements ParseUserController {
    private static final int STATUS_CODE_CREATED = 201;
    private final ParseHttpClient client;
    private final ParseObjectCoder coder;
    private final boolean revocableSession;

    public NetworkUserController(ParseHttpClient client) {
        this(client, false);
    }

    public NetworkUserController(ParseHttpClient client, boolean revocableSession) {
        this.client = client;
        this.coder = ParseObjectCoder.get();
        this.revocableSession = revocableSession;
    }

    @Override
    public Task<ParseUser.State> signUpAsync(ParseObject.State state, ParseOperationSet operations, String sessionToken) {
        JSONObject objectJSON = this.coder.encode(state, operations, PointerEncoder.get());
        ParseRESTUserCommand command = ParseRESTUserCommand.signUpUserCommand(objectJSON, sessionToken, this.revocableSession);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, ParseUser.State>(){

            public ParseUser.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return ((ParseUser.State.Builder)NetworkUserController.this.coder.decode(new ParseUser.State.Builder(), result, ParseDecoder.get()).isComplete(false)).isNew(true).build();
            }
        });
    }

    @Override
    public Task<ParseUser.State> logInAsync(String username, String password) {
        ParseRESTUserCommand command = ParseRESTUserCommand.logInUserCommand(username, password, this.revocableSession);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, ParseUser.State>(){

            public ParseUser.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return ((ParseUser.State.Builder)NetworkUserController.this.coder.decode(new ParseUser.State.Builder(), result, ParseDecoder.get()).isComplete(true)).build();
            }
        });
    }

    @Override
    public Task<ParseUser.State> logInAsync(ParseUser.State state, ParseOperationSet operations) {
        JSONObject objectJSON = this.coder.encode(state, operations, PointerEncoder.get());
        final ParseRESTUserCommand command = ParseRESTUserCommand.serviceLogInUserCommand(objectJSON, state.sessionToken(), this.revocableSession);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, ParseUser.State>(){

            public ParseUser.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                boolean isNew = command.getStatusCode() == 201;
                boolean isComplete = !isNew;
                return ((ParseUser.State.Builder)NetworkUserController.this.coder.decode(new ParseUser.State.Builder(), result, ParseDecoder.get()).isComplete(isComplete)).isNew(isNew).build();
            }
        });
    }

    @Override
    public Task<ParseUser.State> logInAsync(final String authType, final Map<String, String> authData) {
        final ParseRESTUserCommand command = ParseRESTUserCommand.serviceLogInUserCommand(authType, authData, this.revocableSession);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, ParseUser.State>(){

            public ParseUser.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return ((ParseUser.State.Builder)NetworkUserController.this.coder.decode(new ParseUser.State.Builder(), result, ParseDecoder.get()).isComplete(true)).isNew(command.getStatusCode() == 201).putAuthData(authType, authData).build();
            }
        });
    }

    @Override
    public Task<ParseUser.State> getUserAsync(String sessionToken) {
        ParseRESTUserCommand command = ParseRESTUserCommand.getCurrentUserCommand(sessionToken);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, ParseUser.State>(){

            public ParseUser.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return ((ParseUser.State.Builder)NetworkUserController.this.coder.decode(new ParseUser.State.Builder(), result, ParseDecoder.get()).isComplete(true)).build();
            }
        });
    }

    @Override
    public Task<Void> requestPasswordResetAsync(String email) {
        ParseRESTUserCommand command = ParseRESTUserCommand.resetPasswordResetCommand(email);
        return command.executeAsync(this.client).makeVoid();
    }
}

