/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ParseCorePlugins;
import com.parse.ParseObject;
import com.parse.ParseObjectStore;
import com.parse.ParseObjectSubclassingController;
import com.parse.ParseQuery;
import java.util.Arrays;
import java.util.List;

class OfflineObjectStore<T extends ParseObject>
implements ParseObjectStore<T> {
    private final String className;
    private final String pinName;
    private final ParseObjectStore<T> legacy;

    private static ParseObjectSubclassingController getSubclassingController() {
        return ParseCorePlugins.getInstance().getSubclassingController();
    }

    private static <T extends ParseObject> Task<T> migrate(final ParseObjectStore<T> from, final ParseObjectStore<T> to) {
        return from.getAsync().onSuccessTask(new Continuation<T, Task<T>>(){

            public Task<T> then(Task<T> task) throws Exception {
                final ParseObject object = (ParseObject)task.getResult();
                if (object == null) {
                    return task;
                }
                return Task.whenAll(Arrays.asList(from.deleteAsync(), to.setAsync(object))).continueWith(new Continuation<Void, T>(){

                    public T then(Task<Void> task) throws Exception {
                        return object;
                    }
                });
            }
        });
    }

    public OfflineObjectStore(Class<T> clazz, String pinName, ParseObjectStore<T> legacy) {
        this(OfflineObjectStore.getSubclassingController().getClassName(clazz), pinName, legacy);
    }

    public OfflineObjectStore(String className, String pinName, ParseObjectStore<T> legacy) {
        this.className = className;
        this.pinName = pinName;
        this.legacy = legacy;
    }

    @Override
    public Task<Void> setAsync(final T object) {
        return ParseObject.unpinAllInBackground(this.pinName).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return object.pinInBackground(OfflineObjectStore.this.pinName, false);
            }
        });
    }

    @Override
    public Task<T> getAsync() {
        ParseQuery query = ParseQuery.getQuery(this.className).fromPin(this.pinName).ignoreACLs();
        return query.findInBackground().onSuccessTask(new Continuation<List<T>, Task<T>>(){

            public Task<T> then(Task<List<T>> task) throws Exception {
                List results = (List)task.getResult();
                if (results != null) {
                    if (results.size() == 1) {
                        return Task.forResult(results.get(0));
                    }
                    return ParseObject.unpinAllInBackground(OfflineObjectStore.this.pinName).cast();
                }
                return Task.forResult(null);
            }
        }).onSuccessTask(new Continuation<T, Task<T>>(){

            public Task<T> then(Task<T> task) throws Exception {
                ParseObject ldsObject = (ParseObject)task.getResult();
                if (ldsObject != null) {
                    return task;
                }
                return OfflineObjectStore.migrate(OfflineObjectStore.this.legacy, OfflineObjectStore.this).cast();
            }
        });
    }

    @Override
    public Task<Boolean> existsAsync() {
        ParseQuery query = ParseQuery.getQuery(this.className).fromPin(this.pinName).ignoreACLs();
        return query.countInBackground().onSuccessTask((Continuation)new Continuation<Integer, Task<Boolean>>(){

            public Task<Boolean> then(Task<Integer> task) throws Exception {
                boolean exists;
                boolean bl = exists = (Integer)task.getResult() == 1;
                if (exists) {
                    return Task.forResult((Object)true);
                }
                return OfflineObjectStore.this.legacy.existsAsync();
            }
        });
    }

    @Override
    public Task<Void> deleteAsync() {
        final Task<Void> ldsTask = ParseObject.unpinAllInBackground(this.pinName);
        return Task.whenAll(Arrays.asList(this.legacy.deleteAsync(), ldsTask)).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ldsTask;
            }
        });
    }
}

