/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.Numbers;
import com.parse.OfflineStore;
import com.parse.ParseACL;
import com.parse.ParseException;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseSQLiteDatabase;
import com.parse.ParseUser;
import com.parse.PointerEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OfflineQueryLogic {
    private final OfflineStore store;

    OfflineQueryLogic(OfflineStore store) {
        this.store = store;
    }

    private static Object getValue(Object container, String key) throws ParseException {
        return OfflineQueryLogic.getValue(container, key, 0);
    }

    private static Object getValue(Object container, String key, int depth) throws ParseException {
        if (key.contains(".")) {
            String[] parts = key.split("\\.", 2);
            Object value = OfflineQueryLogic.getValue(container, parts[0], depth + 1);
            if (value != null && value != JSONObject.NULL && !(value instanceof Map) && !(value instanceof JSONObject)) {
                if (depth > 0) {
                    Object restFormat = null;
                    try {
                        restFormat = PointerEncoder.get().encode(value);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (restFormat instanceof JSONObject) {
                        return OfflineQueryLogic.getValue(restFormat, parts[1], depth + 1);
                    }
                }
                throw new ParseException(102, String.format("Key %s is invalid.", key));
            }
            return OfflineQueryLogic.getValue(value, parts[1], depth + 1);
        }
        if (container instanceof ParseObject) {
            ParseObject object = (ParseObject)container;
            if (!object.isDataAvailable()) {
                throw new ParseException(121, String.format("Bad key: %s", key));
            }
            switch (key) {
                case "objectId": {
                    return object.getObjectId();
                }
                case "createdAt": 
                case "_created_at": {
                    return object.getCreatedAt();
                }
                case "updatedAt": 
                case "_updated_at": {
                    return object.getUpdatedAt();
                }
            }
            return object.get(key);
        }
        if (container instanceof JSONObject) {
            return ((JSONObject)container).opt(key);
        }
        if (container instanceof Map) {
            return ((Map)container).get(key);
        }
        if (container == JSONObject.NULL) {
            return null;
        }
        if (container == null) {
            return null;
        }
        throw new ParseException(121, String.format("Bad key: %s", key));
    }

    private static int compareTo(Object lhs, Object rhs) {
        boolean rhsIsNullOrUndefined;
        boolean lhsIsNullOrUndefined = lhs == JSONObject.NULL || lhs == null;
        boolean bl = rhsIsNullOrUndefined = rhs == JSONObject.NULL || rhs == null;
        if (lhsIsNullOrUndefined || rhsIsNullOrUndefined) {
            if (!lhsIsNullOrUndefined) {
                return 1;
            }
            if (!rhsIsNullOrUndefined) {
                return -1;
            }
            return 0;
        }
        if (lhs instanceof Date && rhs instanceof Date) {
            return ((Date)lhs).compareTo((Date)rhs);
        }
        if (lhs instanceof String && rhs instanceof String) {
            return ((String)lhs).compareTo((String)rhs);
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            return Numbers.compare((Number)lhs, (Number)rhs);
        }
        throw new IllegalArgumentException(String.format("Cannot compare %s against %s", lhs, rhs));
    }

    private static boolean compareList(Object constraint, List<?> values, Decider decider) {
        for (Object value : values) {
            if (!decider.decide(constraint, value)) continue;
            return true;
        }
        return false;
    }

    private static boolean compareArray(Object constraint, JSONArray values, Decider decider) {
        for (int i = 0; i < values.length(); ++i) {
            try {
                if (!decider.decide(constraint, values.get(i))) continue;
                return true;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private static boolean compare(Object constraint, Object value, Decider decider) {
        if (value instanceof List) {
            return OfflineQueryLogic.compareList(constraint, (List)value, decider);
        }
        if (value instanceof JSONArray) {
            return OfflineQueryLogic.compareArray(constraint, (JSONArray)value, decider);
        }
        return decider.decide(constraint, value);
    }

    private static boolean matchesEqualConstraint(Object constraint, Object value) {
        if (constraint == null || value == null) {
            return constraint == value;
        }
        if (constraint instanceof Number && value instanceof Number) {
            return OfflineQueryLogic.compareTo(constraint, value) == 0;
        }
        if (constraint instanceof ParseGeoPoint && value instanceof ParseGeoPoint) {
            ParseGeoPoint lhs = (ParseGeoPoint)constraint;
            ParseGeoPoint rhs = (ParseGeoPoint)value;
            return lhs.getLatitude() == rhs.getLatitude() && lhs.getLongitude() == rhs.getLongitude();
        }
        return OfflineQueryLogic.compare(constraint, value, new Decider(){

            @Override
            public boolean decide(Object constraint, Object value) {
                return constraint.equals(value);
            }
        });
    }

    private static boolean matchesNotEqualConstraint(Object constraint, Object value) {
        return !OfflineQueryLogic.matchesEqualConstraint(constraint, value);
    }

    private static boolean matchesLessThanConstraint(Object constraint, Object value) {
        return OfflineQueryLogic.compare(constraint, value, new Decider(){

            @Override
            public boolean decide(Object constraint, Object value) {
                if (value == null || value == JSONObject.NULL) {
                    return false;
                }
                return OfflineQueryLogic.compareTo(constraint, value) > 0;
            }
        });
    }

    private static boolean matchesLessThanOrEqualToConstraint(Object constraint, Object value) {
        return OfflineQueryLogic.compare(constraint, value, new Decider(){

            @Override
            public boolean decide(Object constraint, Object value) {
                if (value == null || value == JSONObject.NULL) {
                    return false;
                }
                return OfflineQueryLogic.compareTo(constraint, value) >= 0;
            }
        });
    }

    private static boolean matchesGreaterThanConstraint(Object constraint, Object value) {
        return OfflineQueryLogic.compare(constraint, value, new Decider(){

            @Override
            public boolean decide(Object constraint, Object value) {
                if (value == null || value == JSONObject.NULL) {
                    return false;
                }
                return OfflineQueryLogic.compareTo(constraint, value) < 0;
            }
        });
    }

    private static boolean matchesGreaterThanOrEqualToConstraint(Object constraint, Object value) {
        return OfflineQueryLogic.compare(constraint, value, new Decider(){

            @Override
            public boolean decide(Object constraint, Object value) {
                if (value == null || value == JSONObject.NULL) {
                    return false;
                }
                return OfflineQueryLogic.compareTo(constraint, value) <= 0;
            }
        });
    }

    private static boolean matchesInConstraint(Object constraint, Object value) {
        if (constraint instanceof Collection) {
            for (Object requiredItem : (Collection)constraint) {
                if (!OfflineQueryLogic.matchesEqualConstraint(requiredItem, value)) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Constraint type not supported for $in queries.");
    }

    private static boolean matchesNotInConstraint(Object constraint, Object value) {
        return !OfflineQueryLogic.matchesInConstraint(constraint, value);
    }

    private static boolean matchesAllConstraint(Object constraint, Object value) {
        if (value == null || value == JSONObject.NULL) {
            return false;
        }
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("Value type not supported for $all queries.");
        }
        if (constraint instanceof Collection) {
            for (Object requiredItem : (Collection)constraint) {
                if (OfflineQueryLogic.matchesEqualConstraint(requiredItem, value)) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Constraint type not supported for $all queries.");
    }

    private static boolean matchesRegexConstraint(Object constraint, Object value, String options) throws ParseException {
        if (value == null || value == JSONObject.NULL) {
            return false;
        }
        if (options == null) {
            options = "";
        }
        if (!options.matches("^[imxs]*$")) {
            throw new ParseException(102, String.format("Invalid regex options: %s", options));
        }
        int flags = 0;
        if (options.contains("i")) {
            flags |= 2;
        }
        if (options.contains("m")) {
            flags |= 8;
        }
        if (options.contains("x")) {
            flags |= 4;
        }
        if (options.contains("s")) {
            flags |= 0x20;
        }
        String regex = (String)constraint;
        Pattern pattern = Pattern.compile(regex, flags);
        Matcher matcher = pattern.matcher((String)value);
        return matcher.find();
    }

    private static boolean matchesExistsConstraint(Object constraint, Object value) {
        if (constraint != null && ((Boolean)constraint).booleanValue()) {
            return value != null && value != JSONObject.NULL;
        }
        return value == null || value == JSONObject.NULL;
    }

    private static boolean matchesNearSphereConstraint(Object constraint, Object value, Double maxDistance) {
        if (value == null || value == JSONObject.NULL) {
            return false;
        }
        if (maxDistance == null) {
            return true;
        }
        ParseGeoPoint point1 = (ParseGeoPoint)constraint;
        ParseGeoPoint point2 = (ParseGeoPoint)value;
        return point1.distanceInRadiansTo(point2) <= maxDistance;
    }

    private static boolean matchesWithinConstraint(Object constraint, Object value) throws ParseException {
        if (value == null || value == JSONObject.NULL) {
            return false;
        }
        HashMap constraintMap = (HashMap)constraint;
        ArrayList box = (ArrayList)constraintMap.get("$box");
        ParseGeoPoint southwest = (ParseGeoPoint)box.get(0);
        ParseGeoPoint northeast = (ParseGeoPoint)box.get(1);
        ParseGeoPoint target = (ParseGeoPoint)value;
        if (northeast.getLongitude() < southwest.getLongitude()) {
            throw new ParseException(102, "whereWithinGeoBox queries cannot cross the International Date Line.");
        }
        if (northeast.getLatitude() < southwest.getLatitude()) {
            throw new ParseException(102, "The southwest corner of a geo box must be south of the northeast corner.");
        }
        if (northeast.getLongitude() - southwest.getLongitude() > 180.0) {
            throw new ParseException(102, "Geo box queries larger than 180 degrees in longitude are not supported. Please check point order.");
        }
        return target.getLatitude() >= southwest.getLatitude() && target.getLatitude() <= northeast.getLatitude() && target.getLongitude() >= southwest.getLongitude() && target.getLongitude() <= northeast.getLongitude();
    }

    private static boolean matchesStatelessConstraint(String operator, Object constraint, Object value, ParseQuery.KeyConstraints allKeyConstraints) throws ParseException {
        switch (operator) {
            case "$ne": {
                return OfflineQueryLogic.matchesNotEqualConstraint(constraint, value);
            }
            case "$lt": {
                return OfflineQueryLogic.matchesLessThanConstraint(constraint, value);
            }
            case "$lte": {
                return OfflineQueryLogic.matchesLessThanOrEqualToConstraint(constraint, value);
            }
            case "$gt": {
                return OfflineQueryLogic.matchesGreaterThanConstraint(constraint, value);
            }
            case "$gte": {
                return OfflineQueryLogic.matchesGreaterThanOrEqualToConstraint(constraint, value);
            }
            case "$in": {
                return OfflineQueryLogic.matchesInConstraint(constraint, value);
            }
            case "$nin": {
                return OfflineQueryLogic.matchesNotInConstraint(constraint, value);
            }
            case "$all": {
                return OfflineQueryLogic.matchesAllConstraint(constraint, value);
            }
            case "$regex": {
                String regexOptions = (String)allKeyConstraints.get("$options");
                return OfflineQueryLogic.matchesRegexConstraint(constraint, value, regexOptions);
            }
            case "$options": {
                return true;
            }
            case "$exists": {
                return OfflineQueryLogic.matchesExistsConstraint(constraint, value);
            }
            case "$nearSphere": {
                Double maxDistance = (Double)allKeyConstraints.get("$maxDistance");
                return OfflineQueryLogic.matchesNearSphereConstraint(constraint, value, maxDistance);
            }
            case "$maxDistance": {
                return true;
            }
            case "$within": {
                return OfflineQueryLogic.matchesWithinConstraint(constraint, value);
            }
        }
        throw new UnsupportedOperationException(String.format("The offline store does not yet support the %s operator.", operator));
    }

    private <T extends ParseObject> ConstraintMatcher<T> createInQueryMatcher(ParseUser user, Object constraint, final String key) {
        ParseQuery.State query = ((ParseQuery.State.Builder)constraint).build();
        return new SubQueryMatcher<T>(user, query){

            @Override
            protected boolean matches(T object, List<T> results) throws ParseException {
                Object value = OfflineQueryLogic.getValue(object, key);
                return OfflineQueryLogic.matchesInConstraint(results, value);
            }
        };
    }

    private <T extends ParseObject> ConstraintMatcher<T> createNotInQueryMatcher(ParseUser user, Object constraint, String key) {
        final ConstraintMatcher<T> inQueryMatcher = this.createInQueryMatcher(user, constraint, key);
        return new ConstraintMatcher<T>(user){

            @Override
            public Task<Boolean> matchesAsync(T object, ParseSQLiteDatabase db) {
                return inQueryMatcher.matchesAsync(object, db).onSuccess((Continuation)new Continuation<Boolean, Boolean>(){

                    public Boolean then(Task<Boolean> task) throws Exception {
                        return (Boolean)task.getResult() == false;
                    }
                });
            }
        };
    }

    private <T extends ParseObject> ConstraintMatcher<T> createSelectMatcher(ParseUser user, Object constraint, final String key) {
        Map constraintMap = (Map)constraint;
        ParseQuery.State query = ((ParseQuery.State.Builder)constraintMap.get("query")).build();
        final String resultKey = (String)constraintMap.get("key");
        return new SubQueryMatcher<T>(user, query){

            @Override
            protected boolean matches(T object, List<T> results) throws ParseException {
                Object value = OfflineQueryLogic.getValue(object, key);
                for (ParseObject result : results) {
                    Object resultValue = OfflineQueryLogic.getValue(result, resultKey);
                    if (!OfflineQueryLogic.matchesEqualConstraint(value, resultValue)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private <T extends ParseObject> ConstraintMatcher<T> createDontSelectMatcher(ParseUser user, Object constraint, String key) {
        final ConstraintMatcher<T> selectMatcher = this.createSelectMatcher(user, constraint, key);
        return new ConstraintMatcher<T>(user){

            @Override
            public Task<Boolean> matchesAsync(T object, ParseSQLiteDatabase db) {
                return selectMatcher.matchesAsync(object, db).onSuccess((Continuation)new Continuation<Boolean, Boolean>(){

                    public Boolean then(Task<Boolean> task) throws Exception {
                        return (Boolean)task.getResult() == false;
                    }
                });
            }
        };
    }

    private <T extends ParseObject> ConstraintMatcher<T> createMatcher(ParseUser user, final String operator, final Object constraint, final String key, final ParseQuery.KeyConstraints allKeyConstraints) {
        switch (operator) {
            case "$inQuery": {
                return this.createInQueryMatcher(user, constraint, key);
            }
            case "$notInQuery": {
                return this.createNotInQueryMatcher(user, constraint, key);
            }
            case "$select": {
                return this.createSelectMatcher(user, constraint, key);
            }
            case "$dontSelect": {
                return this.createDontSelectMatcher(user, constraint, key);
            }
        }
        return new ConstraintMatcher<T>(user){

            @Override
            public Task<Boolean> matchesAsync(T object, ParseSQLiteDatabase db) {
                try {
                    Object value = OfflineQueryLogic.getValue(object, key);
                    return Task.forResult((Object)OfflineQueryLogic.matchesStatelessConstraint(operator, constraint, value, allKeyConstraints));
                }
                catch (ParseException e) {
                    return Task.forError((Exception)e);
                }
            }
        };
    }

    private <T extends ParseObject> ConstraintMatcher<T> createOrMatcher(ParseUser user, ArrayList<ParseQuery.QueryConstraints> queries) {
        final ArrayList<ConstraintMatcher<T>> matchers = new ArrayList<ConstraintMatcher<T>>();
        for (ParseQuery.QueryConstraints constraints : queries) {
            ConstraintMatcher<T> matcher = this.createMatcher(user, constraints);
            matchers.add(matcher);
        }
        return new ConstraintMatcher<T>(user){

            @Override
            public Task<Boolean> matchesAsync(final T object, final ParseSQLiteDatabase db) {
                Task task = Task.forResult((Object)false);
                for (final ConstraintMatcher matcher : matchers) {
                    task = task.onSuccessTask((Continuation)new Continuation<Boolean, Task<Boolean>>(){

                        public Task<Boolean> then(Task<Boolean> task) throws Exception {
                            if (((Boolean)task.getResult()).booleanValue()) {
                                return task;
                            }
                            return matcher.matchesAsync(object, db);
                        }
                    });
                }
                return task;
            }
        };
    }

    private <T extends ParseObject> ConstraintMatcher<T> createMatcher(ParseUser user, ParseQuery.QueryConstraints queryConstraints) {
        final ArrayList<ConstraintMatcher<T>> matchers = new ArrayList<ConstraintMatcher<T>>();
        for (final String key : queryConstraints.keySet()) {
            final Object queryConstraintValue = queryConstraints.get(key);
            if (key.equals("$or")) {
                ConstraintMatcher<T> matcher = this.createOrMatcher(user, (ArrayList)queryConstraintValue);
                matchers.add(matcher);
                continue;
            }
            if (queryConstraintValue instanceof ParseQuery.KeyConstraints) {
                ParseQuery.KeyConstraints keyConstraints = (ParseQuery.KeyConstraints)queryConstraintValue;
                for (String operator : keyConstraints.keySet()) {
                    Object keyConstraintValue = keyConstraints.get(operator);
                    ConstraintMatcher<T> matcher = this.createMatcher(user, operator, keyConstraintValue, key, keyConstraints);
                    matchers.add(matcher);
                }
                continue;
            }
            if (queryConstraintValue instanceof ParseQuery.RelationConstraint) {
                final ParseQuery.RelationConstraint relation = (ParseQuery.RelationConstraint)queryConstraintValue;
                matchers.add(new ConstraintMatcher<T>(user){

                    @Override
                    public Task<Boolean> matchesAsync(T object, ParseSQLiteDatabase db) {
                        return Task.forResult((Object)relation.getRelation().hasKnownObject((ParseObject)object));
                    }
                });
                continue;
            }
            matchers.add(new ConstraintMatcher<T>(user){

                @Override
                public Task<Boolean> matchesAsync(T object, ParseSQLiteDatabase db) {
                    Object objectValue;
                    try {
                        objectValue = OfflineQueryLogic.getValue(object, key);
                    }
                    catch (ParseException e) {
                        return Task.forError((Exception)e);
                    }
                    return Task.forResult((Object)OfflineQueryLogic.matchesEqualConstraint(queryConstraintValue, objectValue));
                }
            });
        }
        return new ConstraintMatcher<T>(user){

            @Override
            public Task<Boolean> matchesAsync(final T object, final ParseSQLiteDatabase db) {
                Task task = Task.forResult((Object)true);
                for (final ConstraintMatcher matcher : matchers) {
                    task = task.onSuccessTask((Continuation)new Continuation<Boolean, Task<Boolean>>(){

                        public Task<Boolean> then(Task<Boolean> task) throws Exception {
                            if (!((Boolean)task.getResult()).booleanValue()) {
                                return task;
                            }
                            return matcher.matchesAsync(object, db);
                        }
                    });
                }
                return task;
            }
        };
    }

    static <T extends ParseObject> boolean hasReadAccess(ParseUser user, T object) {
        if (user == object) {
            return true;
        }
        ParseACL acl = object.getACL();
        if (acl == null) {
            return true;
        }
        if (acl.getPublicReadAccess()) {
            return true;
        }
        return user != null && acl.getReadAccess(user);
    }

    static <T extends ParseObject> boolean hasWriteAccess(ParseUser user, T object) {
        if (user == object) {
            return true;
        }
        ParseACL acl = object.getACL();
        if (acl == null) {
            return true;
        }
        if (acl.getPublicWriteAccess()) {
            return true;
        }
        return user != null && acl.getWriteAccess(user);
    }

    <T extends ParseObject> ConstraintMatcher<T> createMatcher(ParseQuery.State<T> state, ParseUser user) {
        final boolean ignoreACLs = state.ignoreACLs();
        final ConstraintMatcher<T> constraintMatcher = this.createMatcher(user, state.constraints());
        return new ConstraintMatcher<T>(user){

            @Override
            public Task<Boolean> matchesAsync(T object, ParseSQLiteDatabase db) {
                if (!ignoreACLs && !OfflineQueryLogic.hasReadAccess(this.user, object)) {
                    return Task.forResult((Object)false);
                }
                return constraintMatcher.matchesAsync(object, db);
            }
        };
    }

    static <T extends ParseObject> void sort(List<T> results, ParseQuery.State<T> state) throws ParseException {
        final List<String> keys = state.order();
        for (String key : state.order()) {
            if (key.matches("^-?[A-Za-z][A-Za-z0-9_]*$") || "_created_at".equals(key) || "_updated_at".equals(key)) continue;
            throw new ParseException(105, String.format("Invalid key name: \"%s\".", key));
        }
        String mutableNearSphereKey = null;
        ParseGeoPoint mutableNearSphereValue = null;
        for (String queryKey : state.constraints().keySet()) {
            ParseQuery.KeyConstraints keyConstraints;
            Object queryKeyConstraints = state.constraints().get(queryKey);
            if (!(queryKeyConstraints instanceof ParseQuery.KeyConstraints) || !(keyConstraints = (ParseQuery.KeyConstraints)queryKeyConstraints).containsKey("$nearSphere")) continue;
            mutableNearSphereKey = queryKey;
            mutableNearSphereValue = (ParseGeoPoint)keyConstraints.get("$nearSphere");
        }
        final String nearSphereKey = mutableNearSphereKey;
        final ParseGeoPoint nearSphereValue = mutableNearSphereValue;
        if (keys.size() == 0 && mutableNearSphereKey == null) {
            return;
        }
        Collections.sort(results, new Comparator<T>(){

            @Override
            public int compare(T lhs, T rhs) {
                if (nearSphereKey != null) {
                    ParseGeoPoint rhsPoint;
                    ParseGeoPoint lhsPoint;
                    try {
                        lhsPoint = (ParseGeoPoint)OfflineQueryLogic.getValue(lhs, nearSphereKey);
                        rhsPoint = (ParseGeoPoint)OfflineQueryLogic.getValue(rhs, nearSphereKey);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                    double lhsDistance = lhsPoint.distanceInRadiansTo(nearSphereValue);
                    double rhsDistance = rhsPoint.distanceInRadiansTo(nearSphereValue);
                    if (lhsDistance != rhsDistance) {
                        return lhsDistance - rhsDistance > 0.0 ? 1 : -1;
                    }
                }
                for (String key : keys) {
                    int result;
                    Object rhsValue;
                    Object lhsValue;
                    boolean descending = false;
                    if (key.startsWith("-")) {
                        descending = true;
                        key = key.substring(1);
                    }
                    try {
                        lhsValue = OfflineQueryLogic.getValue(lhs, key);
                        rhsValue = OfflineQueryLogic.getValue(rhs, key);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        result = OfflineQueryLogic.compareTo(lhsValue, rhsValue);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(String.format("Unable to sort by key %s.", key), e);
                    }
                    if (result == 0) continue;
                    return descending ? -result : result;
                }
                return 0;
            }
        });
    }

    private static Task<Void> fetchIncludeAsync(final OfflineStore store, final Object container, final String path, final ParseSQLiteDatabase db) throws ParseException {
        if (container == null) {
            return Task.forResult(null);
        }
        if (container instanceof Collection) {
            Collection collection = (Collection)container;
            Task task = Task.forResult(null);
            for (final Object item : collection) {
                task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        return OfflineQueryLogic.fetchIncludeAsync(store, item, path, db);
                    }
                });
            }
            return task;
        }
        if (container instanceof JSONArray) {
            final JSONArray array = (JSONArray)container;
            Task task = Task.forResult(null);
            int i = 0;
            while (i < array.length()) {
                final int index = i++;
                task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        return OfflineQueryLogic.fetchIncludeAsync(store, array.get(index), path, db);
                    }
                });
            }
            return task;
        }
        if (path == null) {
            if (JSONObject.NULL.equals(container)) {
                return Task.forResult(null);
            }
            if (container instanceof ParseObject) {
                ParseObject object = (ParseObject)container;
                return store.fetchLocallyAsync(object, db).makeVoid();
            }
            return Task.forError((Exception)new ParseException(121, "include is invalid for non-ParseObjects"));
        }
        String[] parts = path.split("\\.", 2);
        final String key = parts[0];
        final String rest = parts.length > 1 ? parts[1] : null;
        return Task.forResult(null).continueWithTask((Continuation)new Continuation<Void, Task<Object>>(){

            public Task<Object> then(Task<Void> task) throws Exception {
                if (container instanceof ParseObject) {
                    return OfflineQueryLogic.fetchIncludeAsync(store, container, null, db).onSuccess((Continuation)new Continuation<Void, Object>(){

                        public Object then(Task<Void> task) throws Exception {
                            return ((ParseObject)container).get(key);
                        }
                    });
                }
                if (container instanceof Map) {
                    return Task.forResult(((Map)container).get(key));
                }
                if (container instanceof JSONObject) {
                    return Task.forResult((Object)((JSONObject)container).opt(key));
                }
                if (JSONObject.NULL.equals(container)) {
                    return null;
                }
                return Task.forError((Exception)new IllegalStateException("include is invalid"));
            }
        }).onSuccessTask((Continuation)new Continuation<Object, Task<Void>>(){

            public Task<Void> then(Task<Object> task) throws Exception {
                return OfflineQueryLogic.fetchIncludeAsync(store, task.getResult(), rest, db);
            }
        });
    }

    static <T extends ParseObject> Task<Void> fetchIncludesAsync(final OfflineStore store, final T object, ParseQuery.State<T> state, final ParseSQLiteDatabase db) {
        Set<String> includes = state.includes();
        Task task = Task.forResult(null);
        for (final String include : includes) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return OfflineQueryLogic.fetchIncludeAsync(store, object, include, db);
                }
            });
        }
        return task;
    }

    private abstract class SubQueryMatcher<T extends ParseObject>
    extends ConstraintMatcher<T> {
        private final ParseQuery.State<T> subQuery;
        private Task<List<T>> subQueryResults;

        public SubQueryMatcher(ParseUser user, ParseQuery.State<T> subQuery) {
            super(user);
            this.subQueryResults = null;
            this.subQuery = subQuery;
        }

        @Override
        public Task<Boolean> matchesAsync(T object, ParseSQLiteDatabase db) {
            if (this.subQueryResults == null) {
                this.subQueryResults = OfflineQueryLogic.this.store.findAsync(this.subQuery, this.user, null, db);
            }
            return this.subQueryResults.onSuccess(new Continuation<List<T>, Boolean>((ParseObject)object){
                final /* synthetic */ ParseObject val$object;
                {
                    this.val$object = parseObject;
                }

                public Boolean then(Task<List<T>> task) throws ParseException {
                    return SubQueryMatcher.this.matches(this.val$object, (List)task.getResult());
                }
            });
        }

        protected abstract boolean matches(T var1, List<T> var2) throws ParseException;
    }

    private static interface Decider {
        public boolean decide(Object var1, Object var2);
    }

    abstract class ConstraintMatcher<T extends ParseObject> {
        final ParseUser user;

        public ConstraintMatcher(ParseUser user) {
            this.user = user;
        }

        abstract Task<Boolean> matchesAsync(T var1, ParseSQLiteDatabase var2);
    }
}

