/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.GetCallback;
import com.parse.ParseCorePlugins;
import com.parse.ParseDecoder;
import com.parse.ParseDefaultACLController;
import com.parse.ParseEncoder;
import com.parse.ParseException;
import com.parse.ParseJSONUtils;
import com.parse.ParseObject;
import com.parse.ParseRole;
import com.parse.ParseUser;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseACL {
    private static final String PUBLIC_KEY = "*";
    private static final String UNRESOLVED_KEY = "*unresolved";
    private static final String KEY_ROLE_PREFIX = "role:";
    private static final String UNRESOLVED_USER_JSON_KEY = "unresolvedUser";
    private final Map<String, Permissions> permissionsById = new HashMap<String, Permissions>();
    private boolean shared;
    private ParseUser unresolvedUser;

    private static ParseDefaultACLController getDefaultACLController() {
        return ParseCorePlugins.getInstance().getDefaultACLController();
    }

    public static void setDefaultACL(ParseACL acl, boolean withAccessForCurrentUser) {
        ParseACL.getDefaultACLController().set(acl, withAccessForCurrentUser);
    }

    static ParseACL getDefaultACL() {
        return ParseACL.getDefaultACLController().get();
    }

    public ParseACL() {
    }

    public ParseACL(ParseACL acl) {
        for (String id : acl.permissionsById.keySet()) {
            this.permissionsById.put(id, new Permissions(acl.permissionsById.get(id)));
        }
        this.unresolvedUser = acl.unresolvedUser;
        if (this.unresolvedUser != null) {
            this.unresolvedUser.registerSaveListener(new UserResolutionListener(this));
        }
    }

    ParseACL copy() {
        return new ParseACL(this);
    }

    boolean isShared() {
        return this.shared;
    }

    void setShared(boolean shared) {
        this.shared = shared;
    }

    JSONObject toJSONObject(ParseEncoder objectEncoder) {
        JSONObject json = new JSONObject();
        try {
            for (String id : this.permissionsById.keySet()) {
                json.put(id, (Object)this.permissionsById.get(id).toJSONObject());
            }
            if (this.unresolvedUser != null) {
                Object encoded = objectEncoder.encode(this.unresolvedUser);
                json.put(UNRESOLVED_USER_JSON_KEY, encoded);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return json;
    }

    static ParseACL createACLFromJSONObject(JSONObject object, ParseDecoder decoder) {
        ParseACL acl = new ParseACL();
        for (String key : ParseJSONUtils.keys(object)) {
            if (key.equals(UNRESOLVED_USER_JSON_KEY)) {
                JSONObject unresolvedUser;
                try {
                    unresolvedUser = object.getJSONObject(key);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                acl.unresolvedUser = (ParseUser)decoder.decode(unresolvedUser);
                continue;
            }
            try {
                Permissions permissions = Permissions.createPermissionsFromJSONObject(object.getJSONObject(key));
                acl.permissionsById.put(key, permissions);
            }
            catch (JSONException e) {
                throw new RuntimeException("could not decode ACL: " + e.getMessage());
            }
        }
        return acl;
    }

    public ParseACL(ParseUser owner) {
        this();
        this.setReadAccess(owner, true);
        this.setWriteAccess(owner, true);
    }

    void resolveUser(ParseUser user) {
        if (user != this.unresolvedUser) {
            return;
        }
        if (this.permissionsById.containsKey(UNRESOLVED_KEY)) {
            this.permissionsById.put(user.getObjectId(), this.permissionsById.get(UNRESOLVED_KEY));
            this.permissionsById.remove(UNRESOLVED_KEY);
        }
        this.unresolvedUser = null;
    }

    boolean hasUnresolvedUser() {
        return this.unresolvedUser != null;
    }

    ParseUser getUnresolvedUser() {
        return this.unresolvedUser;
    }

    private void setPermissionsIfNonEmpty(String userId, boolean readPermission, boolean writePermission) {
        if (!readPermission && !writePermission) {
            this.permissionsById.remove(userId);
        } else {
            this.permissionsById.put(userId, new Permissions(readPermission, writePermission));
        }
    }

    public void setPublicReadAccess(boolean allowed) {
        this.setReadAccess(PUBLIC_KEY, allowed);
    }

    public boolean getPublicReadAccess() {
        return this.getReadAccess(PUBLIC_KEY);
    }

    public void setPublicWriteAccess(boolean allowed) {
        this.setWriteAccess(PUBLIC_KEY, allowed);
    }

    public boolean getPublicWriteAccess() {
        return this.getWriteAccess(PUBLIC_KEY);
    }

    public void setReadAccess(String userId, boolean allowed) {
        if (userId == null) {
            throw new IllegalArgumentException("cannot setReadAccess for null userId");
        }
        boolean writePermission = this.getWriteAccess(userId);
        this.setPermissionsIfNonEmpty(userId, allowed, writePermission);
    }

    public boolean getReadAccess(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("cannot getReadAccess for null userId");
        }
        Permissions permissions = this.permissionsById.get(userId);
        return permissions != null && permissions.getReadPermission();
    }

    public void setWriteAccess(String userId, boolean allowed) {
        if (userId == null) {
            throw new IllegalArgumentException("cannot setWriteAccess for null userId");
        }
        boolean readPermission = this.getReadAccess(userId);
        this.setPermissionsIfNonEmpty(userId, readPermission, allowed);
    }

    public boolean getWriteAccess(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("cannot getWriteAccess for null userId");
        }
        Permissions permissions = this.permissionsById.get(userId);
        return permissions != null && permissions.getWritePermission();
    }

    public void setReadAccess(ParseUser user, boolean allowed) {
        if (user.getObjectId() == null) {
            if (user.isLazy()) {
                this.setUnresolvedReadAccess(user, allowed);
                return;
            }
            throw new IllegalArgumentException("cannot setReadAccess for a user with null id");
        }
        this.setReadAccess(user.getObjectId(), allowed);
    }

    private void setUnresolvedReadAccess(ParseUser user, boolean allowed) {
        this.prepareUnresolvedUser(user);
        this.setReadAccess(UNRESOLVED_KEY, allowed);
    }

    private void setUnresolvedWriteAccess(ParseUser user, boolean allowed) {
        this.prepareUnresolvedUser(user);
        this.setWriteAccess(UNRESOLVED_KEY, allowed);
    }

    private void prepareUnresolvedUser(ParseUser user) {
        if (this.unresolvedUser != user) {
            this.permissionsById.remove(UNRESOLVED_KEY);
            this.unresolvedUser = user;
            user.registerSaveListener(new UserResolutionListener(this));
        }
    }

    public boolean getReadAccess(ParseUser user) {
        if (user == this.unresolvedUser) {
            return this.getReadAccess(UNRESOLVED_KEY);
        }
        if (user.isLazy()) {
            return false;
        }
        if (user.getObjectId() == null) {
            throw new IllegalArgumentException("cannot getReadAccess for a user with null id");
        }
        return this.getReadAccess(user.getObjectId());
    }

    public void setWriteAccess(ParseUser user, boolean allowed) {
        if (user.getObjectId() == null) {
            if (user.isLazy()) {
                this.setUnresolvedWriteAccess(user, allowed);
                return;
            }
            throw new IllegalArgumentException("cannot setWriteAccess for a user with null id");
        }
        this.setWriteAccess(user.getObjectId(), allowed);
    }

    public boolean getWriteAccess(ParseUser user) {
        if (user == this.unresolvedUser) {
            return this.getWriteAccess(UNRESOLVED_KEY);
        }
        if (user.isLazy()) {
            return false;
        }
        if (user.getObjectId() == null) {
            throw new IllegalArgumentException("cannot getWriteAccess for a user with null id");
        }
        return this.getWriteAccess(user.getObjectId());
    }

    public boolean getRoleReadAccess(String roleName) {
        return this.getReadAccess(KEY_ROLE_PREFIX + roleName);
    }

    public void setRoleReadAccess(String roleName, boolean allowed) {
        this.setReadAccess(KEY_ROLE_PREFIX + roleName, allowed);
    }

    public boolean getRoleWriteAccess(String roleName) {
        return this.getWriteAccess(KEY_ROLE_PREFIX + roleName);
    }

    public void setRoleWriteAccess(String roleName, boolean allowed) {
        this.setWriteAccess(KEY_ROLE_PREFIX + roleName, allowed);
    }

    private static void validateRoleState(ParseRole role) {
        if (role == null || role.getObjectId() == null) {
            throw new IllegalArgumentException("Roles must be saved to the server before they can be used in an ACL.");
        }
    }

    public boolean getRoleReadAccess(ParseRole role) {
        ParseACL.validateRoleState(role);
        return this.getRoleReadAccess(role.getName());
    }

    public void setRoleReadAccess(ParseRole role, boolean allowed) {
        ParseACL.validateRoleState(role);
        this.setRoleReadAccess(role.getName(), allowed);
    }

    public boolean getRoleWriteAccess(ParseRole role) {
        ParseACL.validateRoleState(role);
        return this.getRoleWriteAccess(role.getName());
    }

    public void setRoleWriteAccess(ParseRole role, boolean allowed) {
        ParseACL.validateRoleState(role);
        this.setRoleWriteAccess(role.getName(), allowed);
    }

    Map<String, Permissions> getPermissionsById() {
        return this.permissionsById;
    }

    private static class UserResolutionListener
    implements GetCallback<ParseObject> {
        private final WeakReference<ParseACL> parent;

        public UserResolutionListener(ParseACL parent) {
            this.parent = new WeakReference<ParseACL>(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done(ParseObject object, ParseException e) {
            try {
                ParseACL parent = (ParseACL)this.parent.get();
                if (parent != null) {
                    parent.resolveUser((ParseUser)object);
                }
            }
            finally {
                object.unregisterSaveListener(this);
            }
        }
    }

    private static class Permissions {
        private static final String READ_PERMISSION = "read";
        private static final String WRITE_PERMISSION = "write";
        private final boolean readPermission;
        private final boolean writePermission;

        Permissions(boolean readPermission, boolean write) {
            this.readPermission = readPermission;
            this.writePermission = write;
        }

        Permissions(Permissions permissions) {
            this.readPermission = permissions.readPermission;
            this.writePermission = permissions.writePermission;
        }

        JSONObject toJSONObject() {
            JSONObject json = new JSONObject();
            try {
                if (this.readPermission) {
                    json.put(READ_PERMISSION, true);
                }
                if (this.writePermission) {
                    json.put(WRITE_PERMISSION, true);
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return json;
        }

        boolean getReadPermission() {
            return this.readPermission;
        }

        boolean getWritePermission() {
            return this.writePermission;
        }

        static Permissions createPermissionsFromJSONObject(JSONObject object) {
            boolean read = object.optBoolean(READ_PERMISSION, false);
            boolean write = object.optBoolean(WRITE_PERMISSION, false);
            return new Permissions(read, write);
        }
    }
}

