/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.ParseException;
import com.parse.ParseExecutors;
import com.parse.ParseFileUtils;
import com.parse.ParseIOUtils;
import com.parse.ParseRequest;
import com.parse.ProgressCallback;
import com.parse.http.ParseHttpRequest;
import com.parse.http.ParseHttpResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class ParseAWSRequest
extends ParseRequest<Void> {
    private final File tempFile;

    public ParseAWSRequest(ParseHttpRequest.Method method, String url, File tempFile) {
        super(method, url);
        this.tempFile = tempFile;
    }

    @Override
    protected Task<Void> onResponseAsync(final ParseHttpResponse response, final ProgressCallback downloadProgressCallback) {
        int statusCode = response.getStatusCode();
        if ((statusCode < 200 || statusCode >= 300) && statusCode != 304) {
            String action = this.method == ParseHttpRequest.Method.GET ? "Download from" : "Upload to";
            return Task.forError((Exception)new ParseException(100, String.format("%s S3 failed. %s", action, response.getReasonPhrase())));
        }
        if (this.method != ParseHttpRequest.Method.GET) {
            return null;
        }
        return Task.call((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                long totalSize = response.getTotalSize();
                long downloadedSize = 0L;
                InputStream responseStream = null;
                try {
                    int nRead;
                    responseStream = response.getContent();
                    FileOutputStream tempFileStream = ParseFileUtils.openOutputStream(ParseAWSRequest.this.tempFile);
                    byte[] data = new byte[32768];
                    while ((nRead = responseStream.read(data, 0, data.length)) != -1) {
                        tempFileStream.write(data, 0, nRead);
                        downloadedSize += (long)nRead;
                        if (downloadProgressCallback == null || totalSize == -1L) continue;
                        int progressToReport = Math.round((float)downloadedSize / (float)totalSize * 100.0f);
                        downloadProgressCallback.done(progressToReport);
                    }
                    Void void_ = null;
                    return void_;
                }
                finally {
                    ParseIOUtils.closeQuietly(responseStream);
                }
            }
        }, (Executor)ParseExecutors.io());
    }
}

