/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.AuthenticationCallback;
import com.parse.ParseCurrentUserController;
import com.parse.ParseExecutors;
import com.parse.ParseUser;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class ParseAuthenticationManager {
    private final Object lock = new Object();
    private final Map<String, AuthenticationCallback> callbacks = new HashMap<String, AuthenticationCallback>();
    private final ParseCurrentUserController controller;

    public ParseAuthenticationManager(ParseCurrentUserController controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(final String authType, AuthenticationCallback callback) {
        if (authType == null) {
            throw new IllegalArgumentException("Invalid authType: " + null);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.callbacks.containsKey(authType)) {
                throw new IllegalStateException("Callback already registered for <" + authType + ">: " + this.callbacks.get(authType));
            }
            this.callbacks.put(authType, callback);
        }
        if ("anonymous".equals(authType)) {
            return;
        }
        this.controller.getAsync(false).onSuccessTask((Continuation)new Continuation<ParseUser, Task<Void>>(){

            public Task<Void> then(Task<ParseUser> task) throws Exception {
                ParseUser user = (ParseUser)task.getResult();
                if (user != null) {
                    return user.synchronizeAuthDataAsync(authType);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Boolean> restoreAuthenticationAsync(String authType, final Map<String, String> authData) {
        AuthenticationCallback callback;
        Object object = this.lock;
        synchronized (object) {
            callback = this.callbacks.get(authType);
        }
        if (callback == null) {
            return Task.forResult((Object)true);
        }
        return Task.call((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return callback.onRestore(authData);
            }
        }, (Executor)ParseExecutors.io());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> deauthenticateAsync(String authType) {
        AuthenticationCallback callback;
        Object object = this.lock;
        synchronized (object) {
            callback = this.callbacks.get(authType);
        }
        if (callback != null) {
            return Task.call((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    callback.onRestore(null);
                    return null;
                }
            }, (Executor)ParseExecutors.io());
        }
        return Task.forResult(null);
    }
}

