/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseFileHttpBody;
import com.parse.ParseIOUtils;
import com.parse.ProgressCallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

class ParseCountingFileHttpBody
extends ParseFileHttpBody {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private static final int EOF = -1;
    private final ProgressCallback progressCallback;

    public ParseCountingFileHttpBody(File file, ProgressCallback progressCallback) {
        this(file, null, progressCallback);
    }

    public ParseCountingFileHttpBody(File file, String contentType, ProgressCallback progressCallback) {
        super(file, contentType);
        this.progressCallback = progressCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream output) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        FileInputStream fileInput = new FileInputStream(this.file);
        try {
            int n;
            byte[] buffer = new byte[4096];
            long totalLength = this.file.length();
            long position = 0L;
            while (-1 != (n = fileInput.read(buffer))) {
                output.write(buffer, 0, n);
                position += (long)n;
                if (this.progressCallback == null) continue;
                int progress = (int)(100L * position / totalLength);
                this.progressCallback.done(progress);
            }
        }
        finally {
            ParseIOUtils.closeQuietly(fileInput);
        }
    }
}

