/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.http.ParseHttpRequest;
import com.parse.http.ParseHttpResponse;
import com.parse.http.ParseNetworkInterceptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

class ParseDecompressInterceptor
implements ParseNetworkInterceptor {
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String GZIP_ENCODING = "gzip";

    ParseDecompressInterceptor() {
    }

    @Override
    public ParseHttpResponse intercept(ParseNetworkInterceptor.Chain chain) throws IOException {
        ParseHttpRequest request = chain.getRequest();
        ParseHttpResponse response = chain.proceed(request);
        if (GZIP_ENCODING.equalsIgnoreCase(response.getHeader(CONTENT_ENCODING_HEADER))) {
            HashMap<String, String> newHeaders = new HashMap<String, String>(response.getAllHeaders());
            newHeaders.remove(CONTENT_ENCODING_HEADER);
            newHeaders.put(CONTENT_LENGTH_HEADER, "-1");
            response = new ParseHttpResponse.Builder(response).setTotalSize(-1L).setHeaders(newHeaders).setContent(new GZIPInputStream(response.getContent())).build();
        }
        return response;
    }
}

