/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseAddOperation;
import com.parse.ParseAddUniqueOperation;
import com.parse.ParseDecoder;
import com.parse.ParseDeleteOperation;
import com.parse.ParseFieldOperation;
import com.parse.ParseIncrementOperation;
import com.parse.ParseRelationOperation;
import com.parse.ParseRemoveOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class ParseFieldOperations {
    private static Map<String, ParseFieldOperationFactory> opDecoderMap = new HashMap<String, ParseFieldOperationFactory>();

    private ParseFieldOperations() {
    }

    private static void registerDecoder(String opName, ParseFieldOperationFactory factory) {
        opDecoderMap.put(opName, factory);
    }

    static void registerDefaultDecoders() {
        ParseFieldOperations.registerDecoder("Batch", new ParseFieldOperationFactory(){

            @Override
            public ParseFieldOperation decode(JSONObject object, ParseDecoder decoder) throws JSONException {
                ParseFieldOperation op = null;
                JSONArray ops = object.getJSONArray("ops");
                for (int i = 0; i < ops.length(); ++i) {
                    ParseFieldOperation nextOp = ParseFieldOperations.decode(ops.getJSONObject(i), decoder);
                    op = nextOp.mergeWithPrevious(op);
                }
                return op;
            }
        });
        ParseFieldOperations.registerDecoder("Delete", new ParseFieldOperationFactory(){

            @Override
            public ParseFieldOperation decode(JSONObject object, ParseDecoder decoder) throws JSONException {
                return ParseDeleteOperation.getInstance();
            }
        });
        ParseFieldOperations.registerDecoder("Increment", new ParseFieldOperationFactory(){

            @Override
            public ParseFieldOperation decode(JSONObject object, ParseDecoder decoder) throws JSONException {
                return new ParseIncrementOperation((Number)decoder.decode(object.opt("amount")));
            }
        });
        ParseFieldOperations.registerDecoder("Add", new ParseFieldOperationFactory(){

            @Override
            public ParseFieldOperation decode(JSONObject object, ParseDecoder decoder) throws JSONException {
                return new ParseAddOperation((Collection)decoder.decode(object.opt("objects")));
            }
        });
        ParseFieldOperations.registerDecoder("AddUnique", new ParseFieldOperationFactory(){

            @Override
            public ParseFieldOperation decode(JSONObject object, ParseDecoder decoder) throws JSONException {
                return new ParseAddUniqueOperation((Collection)decoder.decode(object.opt("objects")));
            }
        });
        ParseFieldOperations.registerDecoder("Remove", new ParseFieldOperationFactory(){

            @Override
            public ParseFieldOperation decode(JSONObject object, ParseDecoder decoder) throws JSONException {
                return new ParseRemoveOperation((Collection)decoder.decode(object.opt("objects")));
            }
        });
        ParseFieldOperations.registerDecoder("AddRelation", new ParseFieldOperationFactory(){

            @Override
            public ParseFieldOperation decode(JSONObject object, ParseDecoder decoder) throws JSONException {
                JSONArray objectsArray = object.optJSONArray("objects");
                List objectsList = (List)decoder.decode(objectsArray);
                return new ParseRelationOperation(new HashSet(objectsList), null);
            }
        });
        ParseFieldOperations.registerDecoder("RemoveRelation", new ParseFieldOperationFactory(){

            @Override
            public ParseFieldOperation decode(JSONObject object, ParseDecoder decoder) throws JSONException {
                JSONArray objectsArray = object.optJSONArray("objects");
                List objectsList = (List)decoder.decode(objectsArray);
                return new ParseRelationOperation(null, new HashSet(objectsList));
            }
        });
    }

    static ParseFieldOperation decode(JSONObject encoded, ParseDecoder decoder) throws JSONException {
        String op = encoded.optString("__op");
        ParseFieldOperationFactory factory = opDecoderMap.get(op);
        if (factory == null) {
            throw new RuntimeException("Unable to decode operation of type " + op);
        }
        return factory.decode(encoded, decoder);
    }

    static ArrayList<Object> jsonArrayAsArrayList(JSONArray array) {
        ArrayList<Object> result = new ArrayList<Object>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            try {
                result.add(array.get(i));
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static interface ParseFieldOperationFactory {
        public ParseFieldOperation decode(JSONObject var1, ParseDecoder var2) throws JSONException;
    }
}

