/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import bolts.TaskCompletionSource;
import com.parse.GetDataCallback;
import com.parse.GetDataStreamCallback;
import com.parse.GetFileCallback;
import com.parse.ParseCorePlugins;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseExecutors;
import com.parse.ParseFileController;
import com.parse.ParseFileUtils;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;
import com.parse.ProgressCallback;
import com.parse.SaveCallback;
import com.parse.TaskQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseFile {
    static final int MAX_FILE_SIZE = 0xA00000;
    private State state;
    byte[] data;
    File file;
    final TaskQueue taskQueue = new TaskQueue();
    private Set<TaskCompletionSource<?>> currentTasks = Collections.synchronizedSet(new HashSet());

    static ParseFileController getFileController() {
        return ParseCorePlugins.getInstance().getFileController();
    }

    private static ProgressCallback progressCallbackOnMainThread(final ProgressCallback progressCallback) {
        if (progressCallback == null) {
            return null;
        }
        return new ProgressCallback(){

            @Override
            public void done(final Integer percentDone) {
                Task.call((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        progressCallback.done(percentDone);
                        return null;
                    }
                }, (Executor)ParseExecutors.main());
            }
        };
    }

    public ParseFile(File file) {
        this(file, null);
    }

    public ParseFile(File file, String contentType) {
        this(new State.Builder().name(file.getName()).mimeType(contentType).build());
        if (file.length() > 0xA00000L) {
            throw new IllegalArgumentException(String.format("ParseFile must be less than %d bytes", 0xA00000));
        }
        this.file = file;
    }

    public ParseFile(String name, byte[] data, String contentType) {
        this(new State.Builder().name(name).mimeType(contentType).build());
        if (data.length > 0xA00000) {
            throw new IllegalArgumentException(String.format("ParseFile must be less than %d bytes", 0xA00000));
        }
        this.data = data;
    }

    public ParseFile(byte[] data) {
        this(null, data, null);
    }

    public ParseFile(String name, byte[] data) {
        this(name, data, null);
    }

    public ParseFile(byte[] data, String contentType) {
        this(null, data, contentType);
    }

    ParseFile(State state) {
        this.state = state;
    }

    State getState() {
        return this.state;
    }

    public String getName() {
        return this.state.name();
    }

    public boolean isDirty() {
        return this.state.url() == null;
    }

    public boolean isDataAvailable() {
        return this.data != null || ParseFile.getFileController().isDataAvailable(this.state);
    }

    public String getUrl() {
        return this.state.url();
    }

    public void save() throws ParseException {
        ParseTaskUtils.wait(this.saveInBackground());
    }

    private Task<Void> saveAsync(final String sessionToken, final ProgressCallback uploadProgressCallback, Task<Void> toAwait, final Task<Void> cancellationToken) {
        if (!this.isDirty()) {
            return Task.forResult(null);
        }
        if (cancellationToken != null && cancellationToken.isCancelled()) {
            return Task.cancelled();
        }
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                if (!ParseFile.this.isDirty()) {
                    return Task.forResult(null);
                }
                if (cancellationToken != null && cancellationToken.isCancelled()) {
                    return Task.cancelled();
                }
                Task<State> saveTask = ParseFile.this.data != null ? ParseFile.getFileController().saveAsync(ParseFile.this.state, ParseFile.this.data, sessionToken, ParseFile.progressCallbackOnMainThread(uploadProgressCallback), (Task<Void>)cancellationToken) : ParseFile.getFileController().saveAsync(ParseFile.this.state, ParseFile.this.file, sessionToken, ParseFile.progressCallbackOnMainThread(uploadProgressCallback), (Task<Void>)cancellationToken);
                return saveTask.onSuccessTask((Continuation)new Continuation<State, Task<Void>>(){

                    public Task<Void> then(Task<State> task) throws Exception {
                        ParseFile.this.state = (State)task.getResult();
                        ParseFile.this.data = null;
                        ParseFile.this.file = null;
                        return task.makeVoid();
                    }
                });
            }
        });
    }

    public Task<Void> saveInBackground(final ProgressCallback uploadProgressCallback) {
        final TaskCompletionSource cts = new TaskCompletionSource();
        this.currentTasks.add(cts);
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return ParseFile.this.saveAsync(sessionToken, uploadProgressCallback, (Task<Void>)cts.getTask());
            }
        }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                cts.trySetResult(null);
                ParseFile.this.currentTasks.remove(cts);
                return task;
            }
        });
    }

    Task<Void> saveAsync(final String sessionToken, final ProgressCallback uploadProgressCallback, final Task<Void> cancellationToken) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return ParseFile.this.saveAsync(sessionToken, uploadProgressCallback, (Task<Void>)toAwait, (Task<Void>)cancellationToken);
            }
        });
    }

    public Task<Void> saveInBackground() {
        return this.saveInBackground((ProgressCallback)null);
    }

    public void saveInBackground(SaveCallback saveCallback, ProgressCallback progressCallback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.saveInBackground(progressCallback), saveCallback);
    }

    public void saveInBackground(SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.saveInBackground(), callback);
    }

    public byte[] getData() throws ParseException {
        return ParseTaskUtils.wait(this.getDataInBackground());
    }

    public Task<byte[]> getDataInBackground(final ProgressCallback progressCallback) {
        final TaskCompletionSource cts = new TaskCompletionSource();
        this.currentTasks.add(cts);
        return this.taskQueue.enqueue(new Continuation<Void, Task<byte[]>>(){

            public Task<byte[]> then(Task<Void> toAwait) throws Exception {
                return ParseFile.this.fetchInBackground(progressCallback, (Task<Void>)toAwait, (Task<Void>)cts.getTask()).onSuccess((Continuation)new Continuation<File, byte[]>(){

                    public byte[] then(Task<File> task) throws Exception {
                        File file = (File)task.getResult();
                        try {
                            return ParseFileUtils.readFileToByteArray(file);
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                });
            }
        }).continueWithTask((Continuation)new Continuation<byte[], Task<byte[]>>(){

            public Task<byte[]> then(Task<byte[]> task) throws Exception {
                cts.trySetResult(null);
                ParseFile.this.currentTasks.remove(cts);
                return task;
            }
        });
    }

    public Task<byte[]> getDataInBackground() {
        return this.getDataInBackground((ProgressCallback)null);
    }

    public void getDataInBackground(GetDataCallback dataCallback, ProgressCallback progressCallback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.getDataInBackground(progressCallback), dataCallback);
    }

    public void getDataInBackground(GetDataCallback dataCallback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.getDataInBackground(), dataCallback);
    }

    public File getFile() throws ParseException {
        return ParseTaskUtils.wait(this.getFileInBackground());
    }

    public Task<File> getFileInBackground(final ProgressCallback progressCallback) {
        final TaskCompletionSource cts = new TaskCompletionSource();
        this.currentTasks.add(cts);
        return this.taskQueue.enqueue(new Continuation<Void, Task<File>>(){

            public Task<File> then(Task<Void> toAwait) throws Exception {
                return ParseFile.this.fetchInBackground(progressCallback, (Task<Void>)toAwait, (Task<Void>)cts.getTask());
            }
        }).continueWithTask((Continuation)new Continuation<File, Task<File>>(){

            public Task<File> then(Task<File> task) throws Exception {
                cts.trySetResult(null);
                ParseFile.this.currentTasks.remove(cts);
                return task;
            }
        });
    }

    public Task<File> getFileInBackground() {
        return this.getFileInBackground((ProgressCallback)null);
    }

    public void getFileInBackground(GetFileCallback fileCallback, ProgressCallback progressCallback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.getFileInBackground(progressCallback), fileCallback);
    }

    public void getFileInBackground(GetFileCallback fileCallback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.getFileInBackground(), fileCallback);
    }

    public InputStream getDataStream() throws ParseException {
        return ParseTaskUtils.wait(this.getDataStreamInBackground());
    }

    public Task<InputStream> getDataStreamInBackground(final ProgressCallback progressCallback) {
        final TaskCompletionSource cts = new TaskCompletionSource();
        this.currentTasks.add(cts);
        return this.taskQueue.enqueue(new Continuation<Void, Task<InputStream>>(){

            public Task<InputStream> then(Task<Void> toAwait) throws Exception {
                return ParseFile.this.fetchInBackground(progressCallback, (Task<Void>)toAwait, (Task<Void>)cts.getTask()).onSuccess((Continuation)new Continuation<File, InputStream>(){

                    public InputStream then(Task<File> task) throws Exception {
                        return new FileInputStream((File)task.getResult());
                    }
                });
            }
        }).continueWithTask((Continuation)new Continuation<InputStream, Task<InputStream>>(){

            public Task<InputStream> then(Task<InputStream> task) throws Exception {
                cts.trySetResult(null);
                ParseFile.this.currentTasks.remove(cts);
                return task;
            }
        });
    }

    public Task<InputStream> getDataStreamInBackground() {
        return this.getDataStreamInBackground((ProgressCallback)null);
    }

    public void getDataStreamInBackground(GetDataStreamCallback dataStreamCallback, ProgressCallback progressCallback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.getDataStreamInBackground(progressCallback), dataStreamCallback);
    }

    public void getDataStreamInBackground(GetDataStreamCallback dataStreamCallback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.getDataStreamInBackground(), dataStreamCallback);
    }

    private Task<File> fetchInBackground(final ProgressCallback progressCallback, Task<Void> toAwait, final Task<Void> cancellationToken) {
        if (cancellationToken != null && cancellationToken.isCancelled()) {
            return Task.cancelled();
        }
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<File>>(){

            public Task<File> then(Task<Void> task) throws Exception {
                if (cancellationToken != null && cancellationToken.isCancelled()) {
                    return Task.cancelled();
                }
                return ParseFile.getFileController().fetchAsync(ParseFile.this.state, null, ParseFile.progressCallbackOnMainThread(progressCallback), (Task<Void>)cancellationToken);
            }
        });
    }

    public void cancel() {
        HashSet tasks = new HashSet(this.currentTasks);
        for (TaskCompletionSource taskCompletionSource : tasks) {
            taskCompletionSource.trySetCancelled();
        }
        this.currentTasks.removeAll(tasks);
    }

    ParseFile(JSONObject json, ParseDecoder decoder) {
        this(new State.Builder().name(json.optString("name")).url(json.optString("url")).build());
    }

    JSONObject encode() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("__type", (Object)"File");
        json.put("name", (Object)this.getName());
        String url = this.getUrl();
        if (url == null) {
            throw new IllegalStateException("Unable to encode an unsaved ParseFile.");
        }
        json.put("url", (Object)this.getUrl());
        return json;
    }

    static class State {
        private final String name;
        private final String contentType;
        private final String url;

        private State(Builder builder) {
            this.name = builder.name != null ? builder.name : "file";
            this.contentType = builder.mimeType;
            this.url = builder.url;
        }

        public String name() {
            return this.name;
        }

        public String mimeType() {
            return this.contentType;
        }

        public String url() {
            return this.url;
        }

        static class Builder {
            private String name;
            private String mimeType;
            private String url;

            public Builder() {
            }

            public Builder(State state) {
                this.name = state.name();
                this.mimeType = state.mimeType();
                this.url = state.url();
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder mimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public State build() {
                return new State(this);
            }
        }
    }
}

