/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ParseAWSRequest;
import com.parse.ParseExecutors;
import com.parse.ParseFile;
import com.parse.ParseFileUtils;
import com.parse.ParseHttpClient;
import com.parse.ParsePlugins;
import com.parse.ParseRESTFileCommand;
import com.parse.ProgressCallback;
import com.parse.http.ParseHttpRequest;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import org.json.JSONObject;

class ParseFileController {
    private final Object lock = new Object();
    private final ParseHttpClient restClient;
    private final File cachePath;
    private ParseHttpClient awsClient;

    public ParseFileController(ParseHttpClient restClient, File cachePath) {
        this.restClient = restClient;
        this.cachePath = cachePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParseHttpClient awsClient() {
        Object object = this.lock;
        synchronized (object) {
            if (this.awsClient == null) {
                this.awsClient = ParsePlugins.get().newHttpClient();
            }
            return this.awsClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParseFileController awsClient(ParseHttpClient awsClient) {
        Object object = this.lock;
        synchronized (object) {
            this.awsClient = awsClient;
        }
        return this;
    }

    public File getCacheFile(ParseFile.State state) {
        return new File(this.cachePath, state.name());
    }

    File getTempFile(ParseFile.State state) {
        if (state.url() == null) {
            return null;
        }
        return new File(this.cachePath, state.url() + ".tmp");
    }

    public boolean isDataAvailable(ParseFile.State state) {
        return this.getCacheFile(state).exists();
    }

    public void clearCache() {
        File[] files = this.cachePath.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            ParseFileUtils.deleteQuietly(file);
        }
    }

    public Task<ParseFile.State> saveAsync(final ParseFile.State state, final byte[] data, String sessionToken, ProgressCallback uploadProgressCallback, Task<Void> cancellationToken) {
        if (state.url() != null) {
            return Task.forResult((Object)state);
        }
        if (cancellationToken != null && cancellationToken.isCancelled()) {
            return Task.cancelled();
        }
        ParseRESTFileCommand command = ((ParseRESTFileCommand.Builder)new ParseRESTFileCommand.Builder().fileName(state.name()).data(data).contentType(state.mimeType()).sessionToken(sessionToken)).build();
        command.enableRetrying();
        return command.executeAsync(this.restClient, uploadProgressCallback, null, cancellationToken).onSuccess((Continuation)new Continuation<JSONObject, ParseFile.State>(){

            public ParseFile.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                ParseFile.State newState = new ParseFile.State.Builder(state).name(result.getString("name")).url(result.getString("url")).build();
                try {
                    ParseFileUtils.writeByteArrayToFile(ParseFileController.this.getCacheFile(newState), data);
                }
                catch (IOException e) {
                    // empty catch block
                }
                return newState;
            }
        }, ParseExecutors.io());
    }

    public Task<ParseFile.State> saveAsync(final ParseFile.State state, final File file, String sessionToken, ProgressCallback uploadProgressCallback, Task<Void> cancellationToken) {
        if (state.url() != null) {
            return Task.forResult((Object)state);
        }
        if (cancellationToken != null && cancellationToken.isCancelled()) {
            return Task.cancelled();
        }
        ParseRESTFileCommand command = ((ParseRESTFileCommand.Builder)new ParseRESTFileCommand.Builder().fileName(state.name()).file(file).contentType(state.mimeType()).sessionToken(sessionToken)).build();
        command.enableRetrying();
        return command.executeAsync(this.restClient, uploadProgressCallback, null, cancellationToken).onSuccess((Continuation)new Continuation<JSONObject, ParseFile.State>(){

            public ParseFile.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                ParseFile.State newState = new ParseFile.State.Builder(state).name(result.getString("name")).url(result.getString("url")).build();
                try {
                    ParseFileUtils.copyFile(file, ParseFileController.this.getCacheFile(newState));
                }
                catch (IOException e) {
                    // empty catch block
                }
                return newState;
            }
        }, ParseExecutors.io());
    }

    public Task<File> fetchAsync(final ParseFile.State state, String sessionToken, final ProgressCallback downloadProgressCallback, final Task<Void> cancellationToken) {
        if (cancellationToken != null && cancellationToken.isCancelled()) {
            return Task.cancelled();
        }
        final File cacheFile = this.getCacheFile(state);
        return Task.call((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return cacheFile.exists();
            }
        }, (Executor)ParseExecutors.io()).continueWithTask((Continuation)new Continuation<Boolean, Task<File>>(){

            public Task<File> then(Task<Boolean> task) throws Exception {
                boolean result = (Boolean)task.getResult();
                if (result) {
                    return Task.forResult((Object)cacheFile);
                }
                if (cancellationToken != null && cancellationToken.isCancelled()) {
                    return Task.cancelled();
                }
                final File tempFile = ParseFileController.this.getTempFile(state);
                ParseAWSRequest request = new ParseAWSRequest(ParseHttpRequest.Method.GET, state.url(), tempFile);
                return request.executeAsync(ParseFileController.this.awsClient(), null, downloadProgressCallback, (Task<Void>)cancellationToken).continueWithTask((Continuation)new Continuation<Void, Task<File>>(){

                    public Task<File> then(Task<Void> task) throws Exception {
                        if (cancellationToken != null && cancellationToken.isCancelled()) {
                            throw new CancellationException();
                        }
                        if (task.isFaulted()) {
                            ParseFileUtils.deleteQuietly(tempFile);
                            return task.cast();
                        }
                        ParseFileUtils.deleteQuietly(cacheFile);
                        ParseFileUtils.moveFile(tempFile, cacheFile);
                        return Task.forResult((Object)cacheFile);
                    }
                }, ParseExecutors.io());
            }
        });
    }
}

