/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.location.Criteria;
import android.location.Location;
import bolts.Continuation;
import bolts.Task;
import com.parse.LocationCallback;
import com.parse.LocationNotifier;
import com.parse.Parse;
import com.parse.ParseTaskUtils;
import java.util.Locale;

public class ParseGeoPoint {
    static double EARTH_MEAN_RADIUS_KM = 6371.0;
    static double EARTH_MEAN_RADIUS_MILE = 3958.8;
    private double latitude = 0.0;
    private double longitude = 0.0;

    public ParseGeoPoint() {
    }

    public ParseGeoPoint(double latitude, double longitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
    }

    public ParseGeoPoint(ParseGeoPoint point) {
        this(point.getLatitude(), point.getLongitude());
    }

    public void setLatitude(double latitude) {
        if (latitude > 90.0 || latitude < -90.0) {
            throw new IllegalArgumentException("Latitude must be within the range (-90.0, 90.0).");
        }
        this.latitude = latitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double longitude) {
        if (longitude > 180.0 || longitude < -180.0) {
            throw new IllegalArgumentException("Longitude must be within the range (-180.0, 180.0).");
        }
        this.longitude = longitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double distanceInRadiansTo(ParseGeoPoint point) {
        double d2r = Math.PI / 180;
        double lat1rad = this.latitude * d2r;
        double long1rad = this.longitude * d2r;
        double lat2rad = point.getLatitude() * d2r;
        double long2rad = point.getLongitude() * d2r;
        double deltaLat = lat1rad - lat2rad;
        double deltaLong = long1rad - long2rad;
        double sinDeltaLatDiv2 = Math.sin(deltaLat / 2.0);
        double sinDeltaLongDiv2 = Math.sin(deltaLong / 2.0);
        double a = sinDeltaLatDiv2 * sinDeltaLatDiv2 + Math.cos(lat1rad) * Math.cos(lat2rad) * sinDeltaLongDiv2 * sinDeltaLongDiv2;
        a = Math.min(1.0, a);
        return 2.0 * Math.asin(Math.sqrt(a));
    }

    public double distanceInKilometersTo(ParseGeoPoint point) {
        return this.distanceInRadiansTo(point) * EARTH_MEAN_RADIUS_KM;
    }

    public double distanceInMilesTo(ParseGeoPoint point) {
        return this.distanceInRadiansTo(point) * EARTH_MEAN_RADIUS_MILE;
    }

    public static Task<ParseGeoPoint> getCurrentLocationInBackground(long timeout) {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(0);
        criteria.setPowerRequirement(0);
        return LocationNotifier.getCurrentLocationAsync(Parse.getApplicationContext(), timeout, criteria).onSuccess((Continuation)new Continuation<Location, ParseGeoPoint>(){

            public ParseGeoPoint then(Task<Location> task) throws Exception {
                Location location = (Location)task.getResult();
                return new ParseGeoPoint(location.getLatitude(), location.getLongitude());
            }
        });
    }

    public static void getCurrentLocationInBackground(long timeout, LocationCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseGeoPoint.getCurrentLocationInBackground(timeout), callback);
    }

    public static Task<ParseGeoPoint> getCurrentLocationInBackground(long timeout, Criteria criteria) {
        return LocationNotifier.getCurrentLocationAsync(Parse.getApplicationContext(), timeout, criteria).onSuccess((Continuation)new Continuation<Location, ParseGeoPoint>(){

            public ParseGeoPoint then(Task<Location> task) throws Exception {
                Location location = (Location)task.getResult();
                return new ParseGeoPoint(location.getLatitude(), location.getLongitude());
            }
        });
    }

    public static void getCurrentLocationInBackground(long timeout, Criteria criteria, LocationCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseGeoPoint.getCurrentLocationInBackground(timeout, criteria), callback);
    }

    public String toString() {
        return String.format(Locale.US, "ParseGeoPoint[%.6f,%.6f]", this.latitude, this.longitude);
    }
}

