/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.SSLSessionCache;
import android.os.Build;
import com.parse.PLog;
import com.parse.ParseApacheHttpClient;
import com.parse.ParseOkHttpClient;
import com.parse.ParseURLConnectionHttpClient;
import com.parse.http.ParseHttpRequest;
import com.parse.http.ParseHttpResponse;
import com.parse.http.ParseNetworkInterceptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class ParseHttpClient<LibraryRequest, LibraryResponse> {
    private static final String TAG = "com.parse.ParseHttpClient";
    private static final String APACHE_HTTPCLIENT_NAME = "org.apache.http";
    private static final String URLCONNECTION_NAME = "net.java.URLConnection";
    private static final String OKHTTP_NAME = "com.squareup.okhttp";
    private static final String OKHTTPCLIENT_PATH = "com.squareup.okhttp.OkHttpClient";
    private static final String MAX_CONNECTIONS_PROPERTY_NAME = "http.maxConnections";
    private static final String KEEP_ALIVE_PROPERTY_NAME = "http.keepAlive";
    private boolean hasExecuted;
    private List<ParseNetworkInterceptor> internalInterceptors;
    private List<ParseNetworkInterceptor> externalInterceptors;

    ParseHttpClient() {
    }

    public static ParseHttpClient createClient(int socketOperationTimeout, SSLSessionCache sslSessionCache) {
        ParseHttpClient httpClient;
        String httpClientLibraryName;
        if (ParseHttpClient.hasOkHttpOnClasspath()) {
            httpClientLibraryName = OKHTTP_NAME;
            httpClient = new ParseOkHttpClient(socketOperationTimeout, sslSessionCache);
        } else if (Build.VERSION.SDK_INT >= 19) {
            httpClientLibraryName = URLCONNECTION_NAME;
            httpClient = new ParseURLConnectionHttpClient(socketOperationTimeout, sslSessionCache);
        } else {
            httpClientLibraryName = APACHE_HTTPCLIENT_NAME;
            httpClient = new ParseApacheHttpClient(socketOperationTimeout, sslSessionCache);
        }
        PLog.i(TAG, "Using " + httpClientLibraryName + " library for networking communication.");
        return httpClient;
    }

    public static void setMaxConnections(int maxConnections) {
        if (maxConnections <= 0) {
            throw new IllegalArgumentException("Max connections should be large than 0");
        }
        System.setProperty(MAX_CONNECTIONS_PROPERTY_NAME, String.valueOf(maxConnections));
    }

    public static void setKeepAlive(boolean isKeepAlive) {
        System.setProperty(KEEP_ALIVE_PROPERTY_NAME, String.valueOf(isKeepAlive));
    }

    private static boolean hasOkHttpOnClasspath() {
        try {
            Class.forName(OKHTTPCLIENT_PATH);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    abstract ParseHttpResponse executeInternal(ParseHttpRequest var1) throws IOException;

    abstract LibraryRequest getRequest(ParseHttpRequest var1) throws IOException;

    abstract ParseHttpResponse getResponse(LibraryResponse var1) throws IOException;

    void addInternalInterceptor(ParseNetworkInterceptor interceptor) {
        if (this.hasExecuted) {
            throw new IllegalStateException("`ParseHttpClient#addInternalInterceptor(ParseNetworkInterceptor)` can only be invoked before `ParseHttpClient` execute any request");
        }
        if (this.internalInterceptors == null) {
            this.internalInterceptors = new ArrayList<ParseNetworkInterceptor>();
        }
        this.internalInterceptors.add(interceptor);
    }

    void addExternalInterceptor(ParseNetworkInterceptor interceptor) {
        if (this.externalInterceptors == null) {
            this.externalInterceptors = new ArrayList<ParseNetworkInterceptor>();
        }
        this.externalInterceptors.add(interceptor);
    }

    public final ParseHttpResponse execute(ParseHttpRequest request) throws IOException {
        if (!this.hasExecuted) {
            this.hasExecuted = true;
        }
        ParseNetworkInterceptorChain chain = new ParseNetworkInterceptorChain(0, 0, request);
        return chain.proceed(request);
    }

    boolean disableHttpLibraryAutoDecompress() {
        return this.externalInterceptors != null && this.externalInterceptors.size() > 0;
    }

    private class ParseNetworkInterceptorChain
    implements ParseNetworkInterceptor.Chain {
        private final int internalIndex;
        private final int externalIndex;
        private final ParseHttpRequest request;

        ParseNetworkInterceptorChain(int internalIndex, int externalIndex, ParseHttpRequest request) {
            this.internalIndex = internalIndex;
            this.externalIndex = externalIndex;
            this.request = request;
        }

        @Override
        public ParseHttpRequest getRequest() {
            return this.request;
        }

        @Override
        public ParseHttpResponse proceed(ParseHttpRequest request) throws IOException {
            if (ParseHttpClient.this.internalInterceptors != null && this.internalIndex < ParseHttpClient.this.internalInterceptors.size()) {
                ParseNetworkInterceptorChain chain = new ParseNetworkInterceptorChain(this.internalIndex + 1, this.externalIndex, request);
                return ((ParseNetworkInterceptor)ParseHttpClient.this.internalInterceptors.get(this.internalIndex)).intercept(chain);
            }
            if (ParseHttpClient.this.externalInterceptors != null && this.externalIndex < ParseHttpClient.this.externalInterceptors.size()) {
                ParseNetworkInterceptorChain chain = new ParseNetworkInterceptorChain(this.internalIndex, this.externalIndex + 1, request);
                return ((ParseNetworkInterceptor)ParseHttpClient.this.externalInterceptors.get(this.externalIndex)).intercept(chain);
            }
            return ParseHttpClient.this.executeInternal(request);
        }
    }
}

