/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.PLog;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

class ParseImpreciseDateFormat {
    private static final String TAG = "ParseDateFormat";
    private static final ParseImpreciseDateFormat INSTANCE = new ParseImpreciseDateFormat();
    private final Object lock = new Object();
    private final DateFormat dateFormat;

    public static ParseImpreciseDateFormat getInstance() {
        return INSTANCE;
    }

    private ParseImpreciseDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        format.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.dateFormat = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Date parse(String dateString) {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.dateFormat.parse(dateString);
            }
            catch (ParseException e) {
                PLog.e(TAG, "could not parse date: " + dateString, e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String format(Date date) {
        Object object = this.lock;
        synchronized (object) {
            return this.dateFormat.format(date);
        }
    }
}

