/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseACL;
import com.parse.ParseDateFormat;
import com.parse.ParseDecoder;
import com.parse.ParseEncoder;
import com.parse.ParseFieldOperation;
import com.parse.ParseObject;
import com.parse.ParseOperationSet;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

class ParseObjectCoder {
    private static final String KEY_OBJECT_ID = "objectId";
    private static final String KEY_CLASS_NAME = "className";
    private static final String KEY_ACL = "ACL";
    private static final String KEY_CREATED_AT = "createdAt";
    private static final String KEY_UPDATED_AT = "updatedAt";
    private static final ParseObjectCoder INSTANCE = new ParseObjectCoder();

    public static ParseObjectCoder get() {
        return INSTANCE;
    }

    ParseObjectCoder() {
    }

    public <T extends ParseObject.State> JSONObject encode(T state, ParseOperationSet operations, ParseEncoder encoder) {
        JSONObject objectJSON = new JSONObject();
        try {
            for (String key : operations.keySet()) {
                ParseFieldOperation operation = (ParseFieldOperation)operations.get(key);
                objectJSON.put(key, encoder.encode(operation));
            }
            if (state.objectId() != null) {
                objectJSON.put(KEY_OBJECT_ID, (Object)state.objectId());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize object to JSON");
        }
        return objectJSON;
    }

    public <T extends ParseObject.State.Init<?>> T decode(T builder, JSONObject json, ParseDecoder decoder) {
        try {
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key.equals("__type") || key.equals(KEY_CLASS_NAME)) continue;
                if (key.equals(KEY_OBJECT_ID)) {
                    String newObjectId = json.getString(key);
                    builder.objectId(newObjectId);
                    continue;
                }
                if (key.equals(KEY_CREATED_AT)) {
                    builder.createdAt(ParseDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                if (key.equals(KEY_UPDATED_AT)) {
                    builder.updatedAt(ParseDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                if (key.equals(KEY_ACL)) {
                    ParseACL acl = ParseACL.createACLFromJSONObject(json.getJSONObject(key), decoder);
                    builder.put(KEY_ACL, acl);
                    continue;
                }
                Object value = json.get(key);
                Object decodedObject = decoder.decode(value);
                builder.put(key, decodedObject);
            }
            return builder;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

