/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseDateFormat;
import com.parse.ParseDecoder;
import com.parse.ParseEncoder;
import com.parse.ParseImpreciseDateFormat;
import com.parse.ParseObject;
import com.parse.ParseObjectCoder;
import com.parse.ParseOperationSet;
import java.util.Date;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ParseObjectCurrentCoder
extends ParseObjectCoder {
    private static final String KEY_OBJECT_ID = "objectId";
    private static final String KEY_CLASS_NAME = "classname";
    private static final String KEY_CREATED_AT = "createdAt";
    private static final String KEY_UPDATED_AT = "updatedAt";
    private static final String KEY_DATA = "data";
    private static final String KEY_OLD_OBJECT_ID = "id";
    private static final String KEY_OLD_CREATED_AT = "created_at";
    private static final String KEY_OLD_UPDATED_AT = "updated_at";
    private static final String KEY_OLD_POINTERS = "pointers";
    private static final ParseObjectCurrentCoder INSTANCE = new ParseObjectCurrentCoder();

    public static ParseObjectCurrentCoder get() {
        return INSTANCE;
    }

    ParseObjectCurrentCoder() {
    }

    @Override
    public <T extends ParseObject.State> JSONObject encode(T state, ParseOperationSet operations, ParseEncoder encoder) {
        if (operations != null) {
            throw new IllegalArgumentException("Parameter ParseOperationSet is not null");
        }
        JSONObject objectJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        try {
            for (String key : state.keySet()) {
                Object object = state.get(key);
                dataJSON.put(key, encoder.encode(object));
            }
            if (state.createdAt() > 0L) {
                dataJSON.put(KEY_CREATED_AT, (Object)ParseDateFormat.getInstance().format(new Date(state.createdAt())));
            }
            if (state.updatedAt() > 0L) {
                dataJSON.put(KEY_UPDATED_AT, (Object)ParseDateFormat.getInstance().format(new Date(state.updatedAt())));
            }
            if (state.objectId() != null) {
                dataJSON.put(KEY_OBJECT_ID, (Object)state.objectId());
            }
            objectJSON.put(KEY_DATA, (Object)dataJSON);
            objectJSON.put(KEY_CLASS_NAME, (Object)state.className());
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize object to JSON");
        }
        return objectJSON;
    }

    @Override
    public <T extends ParseObject.State.Init<?>> T decode(T builder, JSONObject json, ParseDecoder decoder) {
        try {
            JSONObject data;
            String key;
            Iterator keys;
            String updatedAtString;
            String createdAtString;
            if (json.has(KEY_OLD_OBJECT_ID)) {
                String newObjectId = json.getString(KEY_OLD_OBJECT_ID);
                builder.objectId(newObjectId);
            }
            if (json.has(KEY_OLD_CREATED_AT) && (createdAtString = json.getString(KEY_OLD_CREATED_AT)) != null) {
                builder.createdAt(ParseImpreciseDateFormat.getInstance().parse(createdAtString));
            }
            if (json.has(KEY_OLD_UPDATED_AT) && (updatedAtString = json.getString(KEY_OLD_UPDATED_AT)) != null) {
                builder.updatedAt(ParseImpreciseDateFormat.getInstance().parse(updatedAtString));
            }
            if (json.has(KEY_OLD_POINTERS)) {
                JSONObject newPointers = json.getJSONObject(KEY_OLD_POINTERS);
                keys = newPointers.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    JSONArray pointerArray = newPointers.getJSONArray(key);
                    builder.put(key, ParseObject.createWithoutData(pointerArray.optString(0), pointerArray.optString(1)));
                }
            }
            if ((data = json.optJSONObject(KEY_DATA)) != null) {
                keys = data.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    if (key.equals(KEY_OBJECT_ID)) {
                        String newObjectId = data.getString(key);
                        builder.objectId(newObjectId);
                        continue;
                    }
                    if (key.equals(KEY_CREATED_AT)) {
                        builder.createdAt(ParseDateFormat.getInstance().parse(data.getString(key)));
                        continue;
                    }
                    if (key.equals(KEY_UPDATED_AT)) {
                        builder.updatedAt(ParseDateFormat.getInstance().parse(data.getString(key)));
                        continue;
                    }
                    Object value = data.get(key);
                    Object decodedObject = decoder.decode(value);
                    builder.put(key, decodedObject);
                }
            }
            return builder;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

