/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import bolts.Capture;
import com.parse.ParseByteArrayHttpBody;
import com.parse.ParseHttpClient;
import com.parse.http.ParseHttpBody;
import com.parse.http.ParseHttpRequest;
import com.parse.http.ParseHttpResponse;
import com.parse.http.ParseNetworkInterceptor;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

class ParseOkHttpClient
extends ParseHttpClient<Request, Response> {
    private static final String OKHTTP_GET = "GET";
    private static final String OKHTTP_POST = "POST";
    private static final String OKHTTP_PUT = "PUT";
    private static final String OKHTTP_DELETE = "DELETE";
    private OkHttpClient okHttpClient = new OkHttpClient();

    public ParseOkHttpClient(int socketOperationTimeout, SSLSessionCache sslSessionCache) {
        this.okHttpClient.setConnectTimeout((long)socketOperationTimeout, TimeUnit.MILLISECONDS);
        this.okHttpClient.setReadTimeout((long)socketOperationTimeout, TimeUnit.MILLISECONDS);
        this.okHttpClient.setFollowRedirects(false);
        this.okHttpClient.setSslSocketFactory(SSLCertificateSocketFactory.getDefault((int)socketOperationTimeout, (SSLSessionCache)sslSessionCache));
    }

    @Override
    ParseHttpResponse executeInternal(ParseHttpRequest parseRequest) throws IOException {
        Request okHttpRequest = this.getRequest(parseRequest);
        Call okHttpCall = this.okHttpClient.newCall(okHttpRequest);
        Response okHttpResponse = okHttpCall.execute();
        return this.getResponse(okHttpResponse);
    }

    @Override
    ParseHttpResponse getResponse(Response okHttpResponse) throws IOException {
        int statusCode = okHttpResponse.code();
        InputStream content = okHttpResponse.body().byteStream();
        int totalSize = (int)okHttpResponse.body().contentLength();
        String reasonPhrase = okHttpResponse.message();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String name : okHttpResponse.headers().names()) {
            headers.put(name, okHttpResponse.header(name));
        }
        String contentType = null;
        ResponseBody body = okHttpResponse.body();
        if (body != null && body.contentType() != null) {
            contentType = body.contentType().toString();
        }
        return new ParseHttpResponse.Builder().setStatusCode(statusCode).setContent(content).setTotalSize(totalSize).setReasonPhrase(reasonPhrase).setHeaders(headers).setContentType(contentType).build();
    }

    @Override
    Request getRequest(ParseHttpRequest parseRequest) throws IOException {
        Request.Builder okHttpRequestBuilder = new Request.Builder();
        ParseHttpRequest.Method method = parseRequest.getMethod();
        switch (method) {
            case GET: {
                okHttpRequestBuilder.get();
                break;
            }
            case DELETE: {
                okHttpRequestBuilder.delete();
                break;
            }
            case POST: 
            case PUT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported http method " + method.toString());
            }
        }
        okHttpRequestBuilder.url(parseRequest.getUrl());
        Headers.Builder okHttpHeadersBuilder = new Headers.Builder();
        for (Map.Entry<String, String> entry : parseRequest.getAllHeaders().entrySet()) {
            okHttpHeadersBuilder.add(entry.getKey(), entry.getValue());
        }
        Headers okHttpHeaders = okHttpHeadersBuilder.build();
        okHttpRequestBuilder.headers(okHttpHeaders);
        ParseHttpBody parseBody = parseRequest.getBody();
        ParseOkHttpRequestBody okHttpRequestBody = null;
        if (parseBody instanceof ParseByteArrayHttpBody) {
            okHttpRequestBody = new ParseOkHttpRequestBody(parseBody);
        }
        switch (method) {
            case PUT: {
                okHttpRequestBuilder.put((RequestBody)okHttpRequestBody);
                break;
            }
            case POST: {
                okHttpRequestBuilder.post((RequestBody)okHttpRequestBody);
            }
        }
        return okHttpRequestBuilder.build();
    }

    private ParseHttpRequest getParseHttpRequest(Request okHttpRequest) {
        ParseHttpRequest.Builder parseRequestBuilder = new ParseHttpRequest.Builder();
        switch (okHttpRequest.method()) {
            case "GET": {
                parseRequestBuilder.setMethod(ParseHttpRequest.Method.GET);
                break;
            }
            case "DELETE": {
                parseRequestBuilder.setMethod(ParseHttpRequest.Method.DELETE);
                break;
            }
            case "POST": {
                parseRequestBuilder.setMethod(ParseHttpRequest.Method.POST);
                break;
            }
            case "PUT": {
                parseRequestBuilder.setMethod(ParseHttpRequest.Method.PUT);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid http method " + okHttpRequest.method());
            }
        }
        parseRequestBuilder.setUrl(okHttpRequest.urlString());
        for (Map.Entry entry : okHttpRequest.headers().toMultimap().entrySet()) {
            parseRequestBuilder.addHeader((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        ParseOkHttpRequestBody okHttpBody = (ParseOkHttpRequestBody)okHttpRequest.body();
        if (okHttpBody != null) {
            parseRequestBuilder.setBody(okHttpBody.getParseHttpBody());
        }
        return parseRequestBuilder.build();
    }

    @Override
    void addExternalInterceptor(final ParseNetworkInterceptor parseNetworkInterceptor) {
        this.okHttpClient.networkInterceptors().add(new Interceptor(){

            public Response intercept(final Interceptor.Chain okHttpChain) throws IOException {
                Request okHttpRequest = okHttpChain.request();
                final ParseHttpRequest parseRequest = ParseOkHttpClient.this.getParseHttpRequest(okHttpRequest);
                final Capture okHttpResponseCapture = new Capture();
                final ParseHttpResponse parseResponse = parseNetworkInterceptor.intercept(new ParseNetworkInterceptor.Chain(){

                    @Override
                    public ParseHttpRequest getRequest() {
                        return parseRequest;
                    }

                    @Override
                    public ParseHttpResponse proceed(ParseHttpRequest parseRequest2) throws IOException {
                        Request okHttpRequest = ParseOkHttpClient.this.getRequest(parseRequest2);
                        Response okHttpResponse = okHttpChain.proceed(okHttpRequest);
                        okHttpResponseCapture.set((Object)okHttpResponse);
                        return ParseOkHttpClient.this.getResponse(okHttpResponse);
                    }
                });
                Response okHttpResponse = (Response)okHttpResponseCapture.get();
                Response.Builder newOkHttpResponseBuilder = okHttpResponse.newBuilder();
                newOkHttpResponseBuilder.code(parseResponse.getStatusCode()).message(parseResponse.getReasonPhrase());
                if (parseResponse.getAllHeaders() != null) {
                    for (Map.Entry<String, String> entry : parseResponse.getAllHeaders().entrySet()) {
                        newOkHttpResponseBuilder.header(entry.getKey(), entry.getValue());
                    }
                }
                newOkHttpResponseBuilder.body(new ResponseBody(){

                    public MediaType contentType() {
                        if (parseResponse.getContentType() == null) {
                            return null;
                        }
                        return MediaType.parse((String)parseResponse.getContentType());
                    }

                    public long contentLength() throws IOException {
                        return parseResponse.getTotalSize();
                    }

                    public BufferedSource source() throws IOException {
                        if (parseResponse.getContent() == null) {
                            return null;
                        }
                        return Okio.buffer((Source)Okio.source((InputStream)parseResponse.getContent()));
                    }
                });
                return newOkHttpResponseBuilder.build();
            }
        });
    }

    private static class ParseOkHttpRequestBody
    extends RequestBody {
        private ParseHttpBody parseBody;

        public ParseOkHttpRequestBody(ParseHttpBody parseBody) {
            this.parseBody = parseBody;
        }

        public long contentLength() throws IOException {
            return this.parseBody.getContentLength();
        }

        public MediaType contentType() {
            String contentType = this.parseBody.getContentType();
            return contentType == null ? null : MediaType.parse((String)this.parseBody.getContentType());
        }

        public void writeTo(BufferedSink bufferedSink) throws IOException {
            this.parseBody.writeTo(bufferedSink.outputStream());
        }

        public ParseHttpBody getParseHttpBody() {
            return this.parseBody;
        }
    }
}

