/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.SSLSessionCache;
import android.os.Build;
import com.parse.InstallationId;
import com.parse.ManifestInfo;
import com.parse.Parse;
import com.parse.ParseHttpClient;
import com.parse.http.ParseHttpRequest;
import com.parse.http.ParseHttpResponse;
import com.parse.http.ParseNetworkInterceptor;
import java.io.File;
import java.io.IOException;

class ParsePlugins {
    private static final String INSTALLATION_ID_LOCATION = "installationId";
    private static final Object LOCK = new Object();
    private static ParsePlugins instance;
    final Object lock = new Object();
    private final String applicationId;
    private final String clientKey;
    private ParseHttpClient restClient;
    private InstallationId installationId;
    File parseDir;
    File cacheDir;
    File filesDir;

    static void initialize(String applicationId, String clientKey) {
        ParsePlugins.set(new ParsePlugins(applicationId, clientKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void set(ParsePlugins plugins) {
        Object object = LOCK;
        synchronized (object) {
            if (instance != null) {
                throw new IllegalStateException("ParsePlugins is already initialized");
            }
            instance = plugins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParsePlugins get() {
        Object object = LOCK;
        synchronized (object) {
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        Object object = LOCK;
        synchronized (object) {
            instance = null;
        }
    }

    private ParsePlugins(String applicationId, String clientKey) {
        this.applicationId = applicationId;
        this.clientKey = clientKey;
    }

    String applicationId() {
        return this.applicationId;
    }

    String clientKey() {
        return this.clientKey;
    }

    ParseHttpClient newHttpClient() {
        int socketOperationTimeout = 10000;
        return ParseHttpClient.createClient(socketOperationTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParseHttpClient restClient() {
        Object object = this.lock;
        synchronized (object) {
            if (this.restClient == null) {
                this.restClient = this.newHttpClient();
                this.restClient.addInternalInterceptor(new ParseNetworkInterceptor(){

                    @Override
                    public ParseHttpResponse intercept(ParseNetworkInterceptor.Chain chain) throws IOException {
                        ParseHttpRequest request = chain.getRequest();
                        ParseHttpRequest.Builder builder = new ParseHttpRequest.Builder(request).addHeader("X-Parse-Application-Id", ParsePlugins.this.applicationId).addHeader("X-Parse-Client-Key", ParsePlugins.this.clientKey).addHeader("X-Parse-Client-Version", Parse.externalVersionName()).addHeader("X-Parse-App-Build-Version", String.valueOf(ManifestInfo.getVersionCode())).addHeader("X-Parse-App-Display-Version", ManifestInfo.getVersionName()).addHeader("X-Parse-OS-Version", Build.VERSION.RELEASE).addHeader("User-Agent", ParsePlugins.this.userAgent());
                        if (request.getHeader("X-Parse-Installation-Id") == null) {
                            builder.addHeader("X-Parse-Installation-Id", ParsePlugins.this.installationId().get());
                        }
                        return chain.proceed(builder.build());
                    }
                });
            }
            return this.restClient;
        }
    }

    String userAgent() {
        return "Parse Java SDK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstallationId installationId() {
        Object object = this.lock;
        synchronized (object) {
            if (this.installationId == null) {
                this.installationId = new InstallationId(new File(this.getParseDir(), INSTALLATION_ID_LOCATION));
            }
            return this.installationId;
        }
    }

    @Deprecated
    File getParseDir() {
        throw new IllegalStateException("Stub");
    }

    File getCacheDir() {
        throw new IllegalStateException("Stub");
    }

    File getFilesDir() {
        throw new IllegalStateException("Stub");
    }

    private static File createFileDir(File file) {
        if (!file.exists() && !file.mkdirs()) {
            return file;
        }
        return file;
    }

    static class Android
    extends ParsePlugins {
        private final Context applicationContext;

        static void initialize(Context context, String applicationId, String clientKey) {
            ParsePlugins.set(new Android(context, applicationId, clientKey));
        }

        static Android get() {
            return (Android)ParsePlugins.get();
        }

        private Android(Context context, String applicationId, String clientKey) {
            super(applicationId, clientKey);
            this.applicationContext = context.getApplicationContext();
        }

        Context applicationContext() {
            return this.applicationContext;
        }

        @Override
        public ParseHttpClient newHttpClient() {
            SSLSessionCache sslSessionCache = new SSLSessionCache(this.applicationContext);
            int socketOperationTimeout = 10000;
            return ParseHttpClient.createClient(socketOperationTimeout, sslSessionCache);
        }

        @Override
        String userAgent() {
            String packageVersion = "unknown";
            try {
                String packageName = this.applicationContext.getPackageName();
                int versionCode = this.applicationContext.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
                packageVersion = packageName + "/" + versionCode;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            return "Parse Android SDK 1.13.0 (" + packageVersion + ") API Level " + Build.VERSION.SDK_INT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        File getParseDir() {
            Object object = this.lock;
            synchronized (object) {
                if (this.parseDir == null) {
                    this.parseDir = this.applicationContext.getDir("Parse", 0);
                }
                return ParsePlugins.createFileDir(this.parseDir);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        File getCacheDir() {
            Object object = this.lock;
            synchronized (object) {
                if (this.cacheDir == null) {
                    this.cacheDir = new File(this.applicationContext.getCacheDir(), "com.parse");
                }
                return ParsePlugins.createFileDir(this.cacheDir);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        File getFilesDir() {
            Object object = this.lock;
            synchronized (object) {
                if (this.filesDir == null) {
                    this.filesDir = new File(this.applicationContext.getFilesDir(), "com.parse");
                }
                return ParsePlugins.createFileDir(this.filesDir);
            }
        }
    }
}

