/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.LocalIdManager;
import com.parse.NoObjectsEncoder;
import com.parse.ParseByteArrayHttpBody;
import com.parse.ParseCorePlugins;
import com.parse.ParseDigestUtils;
import com.parse.ParseHttpClient;
import com.parse.ParseIOUtils;
import com.parse.ParseRequest;
import com.parse.ProgressCallback;
import com.parse.http.ParseHttpBody;
import com.parse.http.ParseHttpRequest;
import com.parse.http.ParseHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

class ParseRESTCommand
extends ParseRequest<JSONObject> {
    static final String HEADER_APPLICATION_ID = "X-Parse-Application-Id";
    static final String HEADER_CLIENT_KEY = "X-Parse-Client-Key";
    static final String HEADER_CLIENT_VERSION = "X-Parse-Client-Version";
    static final String HEADER_APP_BUILD_VERSION = "X-Parse-App-Build-Version";
    static final String HEADER_APP_DISPLAY_VERSION = "X-Parse-App-Display-Version";
    static final String HEADER_OS_VERSION = "X-Parse-OS-Version";
    static final String HEADER_INSTALLATION_ID = "X-Parse-Installation-Id";
    static final String USER_AGENT = "User-Agent";
    private static final String HEADER_SESSION_TOKEN = "X-Parse-Session-Token";
    private static final String HEADER_MASTER_KEY = "X-Parse-Master-Key";
    private static final String PARAMETER_METHOD_OVERRIDE = "_method";
    static URL server = null;
    private final String sessionToken;
    private String installationId;
    public String masterKey;
    String httpPath;
    final JSONObject jsonParameters;
    private String operationSetUUID;
    private String localId;

    private static LocalIdManager getLocalIdManager() {
        return ParseCorePlugins.getInstance().getLocalIdManager();
    }

    public ParseRESTCommand(String httpPath, ParseHttpRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        this(httpPath, httpMethod, parameters != null ? (JSONObject)NoObjectsEncoder.get().encode(parameters) : null, sessionToken);
    }

    public ParseRESTCommand(String httpPath, ParseHttpRequest.Method httpMethod, JSONObject jsonParameters, String sessionToken) {
        this(httpPath, httpMethod, jsonParameters, null, sessionToken);
    }

    private ParseRESTCommand(String httpPath, ParseHttpRequest.Method httpMethod, JSONObject jsonParameters, String localId, String sessionToken) {
        super(httpMethod, ParseRESTCommand.createUrl(httpPath));
        this.httpPath = httpPath;
        this.jsonParameters = jsonParameters;
        this.localId = localId;
        this.sessionToken = sessionToken;
    }

    ParseRESTCommand(Init<?> builder) {
        super(((Init)builder).method, ParseRESTCommand.createUrl(((Init)builder).httpPath));
        this.sessionToken = ((Init)builder).sessionToken;
        this.installationId = ((Init)builder).installationId;
        this.masterKey = builder.masterKey;
        this.httpPath = ((Init)builder).httpPath;
        this.jsonParameters = ((Init)builder).jsonParameters;
        this.operationSetUUID = ((Init)builder).operationSetUUID;
        this.localId = ((Init)builder).localId;
    }

    public static ParseRESTCommand fromJSONObject(JSONObject jsonObject) {
        String httpPath = jsonObject.optString("httpPath");
        ParseHttpRequest.Method httpMethod = ParseHttpRequest.Method.fromString(jsonObject.optString("httpMethod"));
        String sessionToken = jsonObject.optString("sessionToken", null);
        String localId = jsonObject.optString("localId", null);
        JSONObject jsonParameters = jsonObject.optJSONObject("parameters");
        return new ParseRESTCommand(httpPath, httpMethod, jsonParameters, localId, sessionToken);
    }

    void enableRetrying() {
        this.setMaxRetries(4);
    }

    private static String createUrl(String httpPath) {
        if (httpPath == null) {
            return server.toString();
        }
        try {
            return new URL(server, httpPath).toString();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void addAdditionalHeaders(ParseHttpRequest.Builder requestBuilder) {
        if (this.installationId != null) {
            requestBuilder.addHeader(HEADER_INSTALLATION_ID, this.installationId);
        }
        if (this.sessionToken != null) {
            requestBuilder.addHeader(HEADER_SESSION_TOKEN, this.sessionToken);
        }
        if (this.masterKey != null) {
            requestBuilder.addHeader(HEADER_MASTER_KEY, this.masterKey);
        }
    }

    @Override
    protected ParseHttpRequest newRequest(ParseHttpRequest.Method method, String url, ProgressCallback uploadProgressCallback) {
        ParseHttpRequest request = this.jsonParameters != null && method != ParseHttpRequest.Method.POST && method != ParseHttpRequest.Method.PUT ? super.newRequest(ParseHttpRequest.Method.POST, url, uploadProgressCallback) : super.newRequest(method, url, uploadProgressCallback);
        ParseHttpRequest.Builder requestBuilder = new ParseHttpRequest.Builder(request);
        this.addAdditionalHeaders(requestBuilder);
        return requestBuilder.build();
    }

    @Override
    protected ParseHttpBody newBody(ProgressCallback uploadProgressCallback) {
        if (this.jsonParameters == null) {
            String message = String.format("Trying to execute a %s command without body parameters.", this.method.toString());
            throw new IllegalArgumentException(message);
        }
        try {
            JSONObject parameters = this.jsonParameters;
            if (this.method == ParseHttpRequest.Method.GET || this.method == ParseHttpRequest.Method.DELETE) {
                parameters = new JSONObject(this.jsonParameters.toString());
                parameters.put(PARAMETER_METHOD_OVERRIDE, (Object)this.method.toString());
            }
            return new ParseByteArrayHttpBody(parameters.toString(), "application/json");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public Task<JSONObject> executeAsync(ParseHttpClient client, ProgressCallback uploadProgressCallback, ProgressCallback downloadProgressCallback, Task<Void> cancellationToken) {
        this.resolveLocalIds();
        return super.executeAsync(client, uploadProgressCallback, downloadProgressCallback, cancellationToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Task<JSONObject> onResponseAsync(ParseHttpResponse response, ProgressCallback downloadProgressCallback) {
        String content;
        InputStream responseStream = null;
        try {
            responseStream = response.getContent();
            content = new String(ParseIOUtils.toByteArray(responseStream));
        }
        catch (IOException e) {
            Task task = Task.forError((Exception)e);
            return task;
        }
        finally {
            ParseIOUtils.closeQuietly(responseStream);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 200 && statusCode < 600) {
            try {
                JSONObject json = new JSONObject(content);
                if (statusCode >= 400 && statusCode < 500) {
                    return Task.forError((Exception)this.newPermanentException(json.optInt("code"), json.optString("error")));
                }
                if (statusCode >= 500) {
                    return Task.forError((Exception)this.newTemporaryException(json.optInt("code"), json.optString("error")));
                }
                return Task.forResult((Object)json);
            }
            catch (JSONException e) {
                return Task.forError((Exception)this.newTemporaryException("bad json response", e));
            }
        }
        return Task.forError((Exception)this.newPermanentException(-1, content));
    }

    public String getCacheKey() {
        String json;
        if (this.jsonParameters != null) {
            try {
                json = ParseRESTCommand.toDeterministicString(this.jsonParameters);
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            json = "";
        }
        if (this.sessionToken != null) {
            json = json + this.sessionToken;
        }
        return String.format("ParseRESTCommand.%s.%s.%s", this.method.toString(), ParseDigestUtils.md5(this.httpPath), ParseDigestUtils.md5(json));
    }

    static String toDeterministicString(Object o) throws JSONException {
        JSONStringer stringer = new JSONStringer();
        ParseRESTCommand.addToStringer(stringer, o);
        return stringer.toString();
    }

    private static void addToStringer(JSONStringer stringer, Object o) throws JSONException {
        if (o instanceof JSONObject) {
            stringer.object();
            JSONObject object = (JSONObject)o;
            Iterator keyIterator = object.keys();
            ArrayList keys = new ArrayList();
            while (keyIterator.hasNext()) {
                keys.add(keyIterator.next());
            }
            Collections.sort(keys);
            for (String key : keys) {
                stringer.key(key);
                ParseRESTCommand.addToStringer(stringer, object.opt(key));
            }
            stringer.endObject();
            return;
        }
        if (o instanceof JSONArray) {
            JSONArray array = (JSONArray)o;
            stringer.array();
            for (int i = 0; i < array.length(); ++i) {
                ParseRESTCommand.addToStringer(stringer, array.get(i));
            }
            stringer.endArray();
            return;
        }
        stringer.value(o);
    }

    static boolean isValidCommandJSONObject(JSONObject jsonObject) {
        return jsonObject.has("httpPath");
    }

    static boolean isValidOldFormatCommandJSONObject(JSONObject jsonObject) {
        return jsonObject.has("op");
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.httpPath != null) {
                jsonObject.put("httpPath", (Object)this.httpPath);
            }
            jsonObject.put("httpMethod", (Object)this.method.toString());
            if (this.jsonParameters != null) {
                jsonObject.put("parameters", (Object)this.jsonParameters);
            }
            if (this.sessionToken != null) {
                jsonObject.put("sessionToken", (Object)this.sessionToken);
            }
            if (this.localId != null) {
                jsonObject.put("localId", (Object)this.localId);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        return jsonObject;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getOperationSetUUID() {
        return this.operationSetUUID;
    }

    void setOperationSetUUID(String operationSetUUID) {
        this.operationSetUUID = operationSetUUID;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getLocalId() {
        return this.localId;
    }

    private void maybeChangeServerOperation() throws JSONException {
        String objectId;
        if (this.localId != null && (objectId = ParseRESTCommand.getLocalIdManager().getObjectId(this.localId)) != null) {
            this.localId = null;
            this.httpPath = this.httpPath + String.format("/%s", objectId);
            this.url = ParseRESTCommand.createUrl(this.httpPath);
            if (this.httpPath.startsWith("classes") && this.method == ParseHttpRequest.Method.POST) {
                this.method = ParseHttpRequest.Method.PUT;
            }
        }
    }

    public void resolveLocalIds() {
        try {
            ArrayList<JSONObject> localPointers = new ArrayList<JSONObject>();
            ParseRESTCommand.getLocalPointersIn(this.jsonParameters, localPointers);
            for (JSONObject pointer : localPointers) {
                String localId = (String)pointer.get("localId");
                String objectId = ParseRESTCommand.getLocalIdManager().getObjectId(localId);
                if (objectId == null) {
                    throw new IllegalStateException("Tried to serialize a command referencing a new, unsaved object.");
                }
                pointer.put("objectId", (Object)objectId);
                pointer.remove("localId");
            }
            this.maybeChangeServerOperation();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void retainLocalIds() {
        if (this.localId != null) {
            ParseRESTCommand.getLocalIdManager().retainLocalIdOnDisk(this.localId);
        }
        try {
            ArrayList<JSONObject> localPointers = new ArrayList<JSONObject>();
            ParseRESTCommand.getLocalPointersIn(this.jsonParameters, localPointers);
            for (JSONObject pointer : localPointers) {
                String localId = (String)pointer.get("localId");
                ParseRESTCommand.getLocalIdManager().retainLocalIdOnDisk(localId);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void releaseLocalIds() {
        if (this.localId != null) {
            ParseRESTCommand.getLocalIdManager().releaseLocalIdOnDisk(this.localId);
        }
        try {
            ArrayList<JSONObject> localPointers = new ArrayList<JSONObject>();
            ParseRESTCommand.getLocalPointersIn(this.jsonParameters, localPointers);
            for (JSONObject pointer : localPointers) {
                String localId = (String)pointer.get("localId");
                ParseRESTCommand.getLocalIdManager().releaseLocalIdOnDisk(localId);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected static void getLocalPointersIn(Object container, ArrayList<JSONObject> localPointers) throws JSONException {
        if (container instanceof JSONObject) {
            JSONObject object = (JSONObject)container;
            if ("Pointer".equals(object.opt("__type")) && object.has("localId")) {
                localPointers.add((JSONObject)container);
                return;
            }
            Iterator keyIterator = object.keys();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                ParseRESTCommand.getLocalPointersIn(object.get(key), localPointers);
            }
        }
        if (container instanceof JSONArray) {
            JSONArray array = (JSONArray)container;
            for (int i = 0; i < array.length(); ++i) {
                ParseRESTCommand.getLocalPointersIn(array.get(i), localPointers);
            }
        }
    }

    public static class Builder
    extends Init<Builder> {
        @Override
        Builder self() {
            return this;
        }

        public ParseRESTCommand build() {
            return new ParseRESTCommand(this);
        }
    }

    static abstract class Init<T extends Init<T>> {
        private String sessionToken;
        private String installationId;
        public String masterKey;
        private ParseHttpRequest.Method method = ParseHttpRequest.Method.GET;
        private String httpPath;
        private JSONObject jsonParameters;
        private String operationSetUUID;
        private String localId;

        Init() {
        }

        abstract T self();

        public T sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this.self();
        }

        public T installationId(String installationId) {
            this.installationId = installationId;
            return this.self();
        }

        public T masterKey(String masterKey) {
            this.masterKey = masterKey;
            return this.self();
        }

        public T method(ParseHttpRequest.Method method) {
            this.method = method;
            return this.self();
        }

        public T httpPath(String httpPath) {
            this.httpPath = httpPath;
            return this.self();
        }

        public T jsonParameters(JSONObject jsonParameters) {
            this.jsonParameters = jsonParameters;
            return this.self();
        }

        public T operationSetUUID(String operationSetUUID) {
            this.operationSetUUID = operationSetUUID;
            return this.self();
        }

        public T localId(String localId) {
            this.localId = localId;
            return this.self();
        }
    }
}

