/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import bolts.TaskCompletionSource;
import com.parse.Lists;
import com.parse.ParseException;
import com.parse.ParseHttpClient;
import com.parse.ParseIOUtils;
import com.parse.ParseRESTCommand;
import com.parse.ParseRESTObjectCommand;
import com.parse.ProgressCallback;
import com.parse.http.ParseHttpRequest;
import com.parse.http.ParseHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ParseRESTObjectBatchCommand
extends ParseRESTCommand {
    public static final int COMMAND_OBJECT_BATCH_MAX_SIZE = 50;
    private static final String KEY_RESULTS = "results";

    public static List<Task<JSONObject>> executeBatch(ParseHttpClient client, List<ParseRESTObjectCommand> commands, String sessionToken) {
        final int batchSize = commands.size();
        ArrayList<Task<JSONObject>> tasks = new ArrayList<Task<JSONObject>>(batchSize);
        if (batchSize == 1) {
            tasks.add(commands.get(0).executeAsync(client));
            return tasks;
        }
        if (batchSize > 50) {
            List<List<ParseRESTObjectCommand>> batches = Lists.partition(commands, 50);
            int size = batches.size();
            for (int i = 0; i < size; ++i) {
                List<ParseRESTObjectCommand> batch = batches.get(i);
                tasks.addAll(ParseRESTObjectBatchCommand.executeBatch(client, batch, sessionToken));
            }
            return tasks;
        }
        final ArrayList<TaskCompletionSource> tcss = new ArrayList<TaskCompletionSource>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            TaskCompletionSource tcs = new TaskCompletionSource();
            tcss.add(tcs);
            tasks.add((Task<JSONObject>)tcs.getTask());
        }
        JSONObject parameters = new JSONObject();
        JSONArray requests = new JSONArray();
        try {
            for (ParseRESTObjectCommand command : commands) {
                JSONObject requestParameters = new JSONObject();
                requestParameters.put("method", (Object)command.method.toString());
                requestParameters.put("path", (Object)new URL(server, command.httpPath).getPath());
                JSONObject body = command.jsonParameters;
                if (body != null) {
                    requestParameters.put("body", (Object)body);
                }
                requests.put((Object)requestParameters);
            }
            parameters.put("requests", (Object)requests);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        ParseRESTObjectBatchCommand command = new ParseRESTObjectBatchCommand("batch", ParseHttpRequest.Method.POST, parameters, sessionToken);
        command.executeAsync(client).continueWith((Continuation)new Continuation<JSONObject, Void>(){

            public Void then(Task<JSONObject> task) throws Exception {
                int i;
                JSONObject json;
                JSONArray results;
                int resultLength;
                TaskCompletionSource tcs;
                if (task.isFaulted() || task.isCancelled()) {
                    for (int i2 = 0; i2 < batchSize; ++i2) {
                        tcs = (TaskCompletionSource)tcss.get(i2);
                        if (task.isFaulted()) {
                            tcs.setError(task.getError());
                            continue;
                        }
                        tcs.setCancelled();
                    }
                }
                if ((resultLength = (results = (json = (JSONObject)task.getResult()).getJSONArray(ParseRESTObjectBatchCommand.KEY_RESULTS)).length()) != batchSize) {
                    for (i = 0; i < batchSize; ++i) {
                        tcs = (TaskCompletionSource)tcss.get(i);
                        tcs.setError((Exception)new IllegalStateException("Batch command result count expected: " + batchSize + " but was: " + resultLength));
                    }
                }
                for (i = 0; i < batchSize; ++i) {
                    JSONObject result = results.getJSONObject(i);
                    tcs = (TaskCompletionSource)tcss.get(i);
                    if (result.has("success")) {
                        JSONObject success = result.getJSONObject("success");
                        tcs.setResult((Object)success);
                        continue;
                    }
                    if (!result.has("error")) continue;
                    JSONObject error = result.getJSONObject("error");
                    tcs.setError((Exception)new ParseException(error.getInt("code"), error.getString("error")));
                }
                return null;
            }
        });
        return tasks;
    }

    private ParseRESTObjectBatchCommand(String httpPath, ParseHttpRequest.Method httpMethod, JSONObject parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Task<JSONObject> onResponseAsync(ParseHttpResponse response, ProgressCallback downloadProgressCallback) {
        JSONObject json;
        InputStream responseStream = null;
        String content = null;
        try {
            responseStream = response.getContent();
            content = new String(ParseIOUtils.toByteArray(responseStream));
        }
        catch (IOException e) {
            Task task = Task.forError((Exception)e);
            return task;
        }
        finally {
            ParseIOUtils.closeQuietly(responseStream);
        }
        try {
            JSONArray results = new JSONArray(content);
            json = new JSONObject();
            json.put(KEY_RESULTS, (Object)results);
        }
        catch (JSONException e) {
            return Task.forError((Exception)this.newTemporaryException("bad json response", e));
        }
        return Task.forResult((Object)json);
    }
}

