/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.ParseRESTCommand;
import com.parse.PointerEncoder;
import com.parse.ProgressCallback;
import com.parse.http.ParseHttpRequest;
import com.parse.http.ParseHttpResponse;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class ParseRESTUserCommand
extends ParseRESTCommand {
    private static final String HEADER_REVOCABLE_SESSION = "X-Parse-Revocable-Session";
    private static final String HEADER_TRUE = "1";
    private boolean isRevocableSessionEnabled;
    private int statusCode;

    public static ParseRESTUserCommand getCurrentUserCommand(String sessionToken) {
        return new ParseRESTUserCommand("users/me", ParseHttpRequest.Method.GET, null, sessionToken);
    }

    public static ParseRESTUserCommand signUpUserCommand(JSONObject parameters, String sessionToken, boolean revocableSession) {
        return new ParseRESTUserCommand("classes/_User", ParseHttpRequest.Method.POST, parameters, sessionToken, revocableSession);
    }

    public static ParseRESTUserCommand logInUserCommand(String username, String password, boolean revocableSession) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("username", username);
        parameters.put("password", password);
        return new ParseRESTUserCommand("login", ParseHttpRequest.Method.GET, parameters, null, revocableSession);
    }

    public static ParseRESTUserCommand serviceLogInUserCommand(String authType, Map<String, String> authData, boolean revocableSession) {
        JSONObject parameters;
        try {
            JSONObject authenticationData = new JSONObject();
            authenticationData.put(authType, PointerEncoder.get().encode(authData));
            parameters = new JSONObject();
            parameters.put("authData", (Object)authenticationData);
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize object to JSON");
        }
        return ParseRESTUserCommand.serviceLogInUserCommand(parameters, null, revocableSession);
    }

    public static ParseRESTUserCommand serviceLogInUserCommand(JSONObject parameters, String sessionToken, boolean revocableSession) {
        return new ParseRESTUserCommand("users", ParseHttpRequest.Method.POST, parameters, sessionToken, revocableSession);
    }

    public static ParseRESTUserCommand resetPasswordResetCommand(String email) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("email", email);
        return new ParseRESTUserCommand("requestPasswordReset", ParseHttpRequest.Method.POST, parameters, null);
    }

    private ParseRESTUserCommand(String httpPath, ParseHttpRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        this(httpPath, httpMethod, parameters, sessionToken, false);
    }

    private ParseRESTUserCommand(String httpPath, ParseHttpRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken, boolean isRevocableSessionEnabled) {
        super(httpPath, httpMethod, parameters, sessionToken);
        this.isRevocableSessionEnabled = isRevocableSessionEnabled;
    }

    private ParseRESTUserCommand(String httpPath, ParseHttpRequest.Method httpMethod, JSONObject parameters, String sessionToken, boolean isRevocableSessionEnabled) {
        super(httpPath, httpMethod, parameters, sessionToken);
        this.isRevocableSessionEnabled = isRevocableSessionEnabled;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    protected void addAdditionalHeaders(ParseHttpRequest.Builder requestBuilder) {
        super.addAdditionalHeaders(requestBuilder);
        if (this.isRevocableSessionEnabled) {
            requestBuilder.addHeader(HEADER_REVOCABLE_SESSION, HEADER_TRUE);
        }
    }

    @Override
    protected Task<JSONObject> onResponseAsync(ParseHttpResponse response, ProgressCallback progressCallback) {
        this.statusCode = response.getStatusCode();
        return super.onResponseAsync(response, progressCallback);
    }
}

