/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import bolts.Continuation;
import bolts.Task;
import bolts.TaskCompletionSource;
import com.parse.ParseSQLiteCursor;
import com.parse.TaskQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class ParseSQLiteDatabase {
    private static final ExecutorService dbExecutor = Executors.newSingleThreadExecutor();
    private static final TaskQueue taskQueue = new TaskQueue();
    private SQLiteDatabase db;
    private Task<Void> current = null;
    private final Object currentLock = new Object();
    private final TaskCompletionSource<Void> tcs = new TaskCompletionSource();
    private int openFlags;

    static Task<ParseSQLiteDatabase> openDatabaseAsync(SQLiteOpenHelper helper, int flags) {
        final ParseSQLiteDatabase db = new ParseSQLiteDatabase(flags);
        return db.open(helper).continueWithTask((Continuation)new Continuation<Void, Task<ParseSQLiteDatabase>>(){

            public Task<ParseSQLiteDatabase> then(Task<Void> task) throws Exception {
                return Task.forResult((Object)db);
            }
        });
    }

    private ParseSQLiteDatabase(int flags) {
        this.openFlags = flags;
        taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<Void> then(Task<Void> toAwait) throws Exception {
                Object object = ParseSQLiteDatabase.this.currentLock;
                synchronized (object) {
                    ParseSQLiteDatabase.this.current = toAwait;
                }
                return ParseSQLiteDatabase.this.tcs.getTask();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Boolean> isReadOnlyAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.continueWith((Continuation)new Continuation<Void, Boolean>(){

                public Boolean then(Task<Void> task) throws Exception {
                    return ParseSQLiteDatabase.this.db.isReadOnly();
                }
            });
            this.current = task.makeVoid();
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Boolean> isOpenAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.continueWith((Continuation)new Continuation<Void, Boolean>(){

                public Boolean then(Task<Void> task) throws Exception {
                    return ParseSQLiteDatabase.this.db.isOpen();
                }
            });
            this.current = task.makeVoid();
            return task;
        }
    }

    public boolean inTransaction() {
        return this.db.inTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> open(final SQLiteOpenHelper helper) {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.continueWith((Continuation)new Continuation<Void, SQLiteDatabase>(){

                public SQLiteDatabase then(Task<Void> task) throws Exception {
                    return (ParseSQLiteDatabase.this.openFlags & 1) == 1 ? helper.getReadableDatabase() : helper.getWritableDatabase();
                }
            }, (Executor)dbExecutor).continueWithTask((Continuation)new Continuation<SQLiteDatabase, Task<Void>>(){

                public Task<Void> then(Task<SQLiteDatabase> task) throws Exception {
                    ParseSQLiteDatabase.this.db = (SQLiteDatabase)task.getResult();
                    return task.makeVoid();
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
            return this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> beginTransactionAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    ParseSQLiteDatabase.this.db.beginTransaction();
                    return task;
                }
            }, (Executor)dbExecutor);
            return this.current.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> setTransactionSuccessfulAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    ParseSQLiteDatabase.this.db.setTransactionSuccessful();
                    return task;
                }
            }, (Executor)dbExecutor);
            return this.current.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> endTransactionAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.continueWith((Continuation)new Continuation<Void, Void>(){

                public Void then(Task<Void> task) throws Exception {
                    ParseSQLiteDatabase.this.db.endTransaction();
                    return null;
                }
            }, (Executor)dbExecutor);
            return this.current.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> closeAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Task<Void> then(Task<Void> task) throws Exception {
                    try {
                        ParseSQLiteDatabase.this.db.close();
                    }
                    finally {
                        ParseSQLiteDatabase.this.tcs.setResult(null);
                    }
                    return ParseSQLiteDatabase.this.tcs.getTask();
                }
            }, (Executor)dbExecutor);
            return this.current.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Cursor> queryAsync(final String table, final String[] select, final String where, final String[] args) {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.onSuccess((Continuation)new Continuation<Void, Cursor>(){

                public Cursor then(Task<Void> task) throws Exception {
                    return ParseSQLiteDatabase.this.db.query(table, select, where, args, null, null, null);
                }
            }, (Executor)dbExecutor).onSuccess((Continuation)new Continuation<Cursor, Cursor>(){

                public Cursor then(Task<Cursor> task) throws Exception {
                    Cursor cursor = ParseSQLiteCursor.create((Cursor)task.getResult(), dbExecutor);
                    cursor.getCount();
                    return cursor;
                }
            }, (Executor)dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask((Continuation)new Continuation<Cursor, Task<Cursor>>(){

                public Task<Cursor> then(Task<Cursor> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> insertWithOnConflict(final String table, final ContentValues values, final int conflictAlgorithm) {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.onSuccess((Continuation)new Continuation<Void, Long>(){

                public Long then(Task<Void> task) throws Exception {
                    return ParseSQLiteDatabase.this.db.insertWithOnConflict(table, null, values, conflictAlgorithm);
                }
            }, (Executor)dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask((Continuation)new Continuation<Long, Task<Long>>(){

                public Task<Long> then(Task<Long> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR).makeVoid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> insertOrThrowAsync(final String table, final ContentValues values) {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.onSuccess((Continuation)new Continuation<Void, Long>(){

                public Long then(Task<Void> task) throws Exception {
                    return ParseSQLiteDatabase.this.db.insertOrThrow(table, null, values);
                }
            }, (Executor)dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask((Continuation)new Continuation<Long, Task<Long>>(){

                public Task<Long> then(Task<Long> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR).makeVoid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Integer> updateAsync(final String table, final ContentValues values, final String where, final String[] args) {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.onSuccess((Continuation)new Continuation<Void, Integer>(){

                public Integer then(Task<Void> task) throws Exception {
                    return ParseSQLiteDatabase.this.db.update(table, values, where, args);
                }
            }, (Executor)dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask((Continuation)new Continuation<Integer, Task<Integer>>(){

                public Task<Integer> then(Task<Integer> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> deleteAsync(final String table, final String where, final String[] args) {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.onSuccess((Continuation)new Continuation<Void, Integer>(){

                public Integer then(Task<Void> task) throws Exception {
                    return ParseSQLiteDatabase.this.db.delete(table, where, args);
                }
            }, (Executor)dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask((Continuation)new Continuation<Integer, Task<Integer>>(){

                public Task<Integer> then(Task<Integer> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR).makeVoid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Cursor> rawQueryAsync(final String sql, final String[] args) {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.onSuccess((Continuation)new Continuation<Void, Cursor>(){

                public Cursor then(Task<Void> task) throws Exception {
                    return ParseSQLiteDatabase.this.db.rawQuery(sql, args);
                }
            }, (Executor)dbExecutor).onSuccess((Continuation)new Continuation<Cursor, Cursor>(){

                public Cursor then(Task<Cursor> task) throws Exception {
                    Cursor cursor = ParseSQLiteCursor.create((Cursor)task.getResult(), dbExecutor);
                    cursor.getCount();
                    return cursor;
                }
            }, (Executor)dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask((Continuation)new Continuation<Cursor, Task<Cursor>>(){

                public Task<Cursor> then(Task<Cursor> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }
}

