/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseDecoder;
import com.parse.ParseEncoder;
import com.parse.ParseObject;
import com.parse.ParseObjectCurrentCoder;
import com.parse.ParseOperationSet;
import com.parse.ParseUser;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class ParseUserCurrentCoder
extends ParseObjectCurrentCoder {
    private static final String KEY_AUTH_DATA = "auth_data";
    private static final String KEY_SESSION_TOKEN = "session_token";
    private static final ParseUserCurrentCoder INSTANCE = new ParseUserCurrentCoder();

    public static ParseUserCurrentCoder get() {
        return INSTANCE;
    }

    ParseUserCurrentCoder() {
    }

    @Override
    public <T extends ParseObject.State> JSONObject encode(T state, ParseOperationSet operations, ParseEncoder encoder) {
        Map<String, Map<String, String>> authData;
        JSONObject objectJSON = super.encode(state, operations, encoder);
        String sessionToken = ((ParseUser.State)state).sessionToken();
        if (sessionToken != null) {
            try {
                objectJSON.put(KEY_SESSION_TOKEN, (Object)sessionToken);
            }
            catch (JSONException e) {
                throw new RuntimeException("could not encode value for key: session_token");
            }
        }
        if ((authData = ((ParseUser.State)state).authData()).size() > 0) {
            try {
                objectJSON.put(KEY_AUTH_DATA, encoder.encode(authData));
            }
            catch (JSONException e) {
                throw new RuntimeException("could not attach key: auth_data");
            }
        }
        return objectJSON;
    }

    @Override
    public <T extends ParseObject.State.Init<?>> T decode(T builder, JSONObject json, ParseDecoder decoder) {
        JSONObject newAuthData;
        ParseUser.State.Builder userBuilder = (ParseUser.State.Builder)builder;
        String newSessionToken = json.optString(KEY_SESSION_TOKEN, null);
        if (newSessionToken != null) {
            userBuilder.sessionToken(newSessionToken);
            json.remove(KEY_SESSION_TOKEN);
        }
        if ((newAuthData = json.optJSONObject(KEY_AUTH_DATA)) != null) {
            try {
                Iterator i = newAuthData.keys();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    if (newAuthData.isNull(key)) continue;
                    userBuilder.putAuthData(key, (Map)ParseDecoder.get().decode(newAuthData.getJSONObject(key)));
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            json.remove(KEY_AUTH_DATA);
        }
        return super.decode(builder, json, decoder);
    }
}

