/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.parse.PLog;
import com.parse.Parse;
import com.parse.ParseFileUtils;
import com.parse.ParsePlugins;
import com.parse.ParseTextUtils;
import com.parse.PushHistory;
import java.io.File;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

class PushRouter {
    private static final String TAG = "com.parse.ParsePushRouter";
    private static final String LEGACY_STATE_LOCATION = "pushState";
    private static final String STATE_LOCATION = "push";
    private static int MAX_HISTORY_LENGTH = 10;
    private static PushRouter instance;
    private final File diskState;
    private final PushHistory history;

    public static synchronized PushRouter getInstance() {
        if (instance == null) {
            File diskState = new File(ParsePlugins.get().getFilesDir(), STATE_LOCATION);
            File oldDiskState = new File(ParsePlugins.get().getParseDir(), LEGACY_STATE_LOCATION);
            instance = PushRouter.pushRouterFromState(diskState, oldDiskState, MAX_HISTORY_LENGTH);
        }
        return instance;
    }

    static synchronized void resetInstance() {
        ParseFileUtils.deleteQuietly(new File(ParsePlugins.get().getFilesDir(), STATE_LOCATION));
        instance = null;
    }

    static PushRouter pushRouterFromState(File diskState, File oldDiskState, int maxHistoryLength) {
        JSONObject oldState;
        JSONObject state = PushRouter.readJSONFileQuietly(diskState);
        JSONObject historyJSON = state != null ? state.optJSONObject("history") : null;
        PushHistory history = new PushHistory(maxHistoryLength, historyJSON);
        boolean didMigrate = false;
        if (history.getLastReceivedTimestamp() == null && (oldState = PushRouter.readJSONFileQuietly(oldDiskState)) != null) {
            String lastTime = oldState.optString("lastTime", null);
            if (lastTime != null) {
                history.setLastReceivedTimestamp(lastTime);
            }
            didMigrate = true;
        }
        PushRouter router = new PushRouter(diskState, history);
        if (didMigrate) {
            router.saveStateToDisk();
            ParseFileUtils.deleteQuietly(oldDiskState);
        }
        return router;
    }

    private static JSONObject readJSONFileQuietly(File file) {
        JSONObject json = null;
        if (file != null) {
            try {
                json = ParseFileUtils.readFileToJSONObject(file);
            }
            catch (IOException | JSONException throwable) {
                // empty catch block
            }
        }
        return json;
    }

    private PushRouter(File diskState, PushHistory history) {
        this.diskState = diskState;
        this.history = history;
    }

    synchronized JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("history", (Object)this.history.toJSON());
        return json;
    }

    private synchronized void saveStateToDisk() {
        try {
            ParseFileUtils.writeJSONObjectToFile(this.diskState, this.toJSON());
        }
        catch (IOException | JSONException e) {
            PLog.e(TAG, "Unexpected error when serializing push state to " + this.diskState, e);
        }
    }

    public synchronized String getLastReceivedTimestamp() {
        return this.history.getLastReceivedTimestamp();
    }

    public synchronized boolean handlePush(String pushId, String timestamp, String channel, JSONObject data) {
        if (ParseTextUtils.isEmpty(pushId) || ParseTextUtils.isEmpty(timestamp)) {
            return false;
        }
        if (!this.history.tryInsertPush(pushId, timestamp)) {
            return false;
        }
        this.saveStateToDisk();
        Bundle extras = new Bundle();
        extras.putString("com.parse.Channel", channel);
        if (data == null) {
            extras.putString("com.parse.Data", "{}");
        } else {
            extras.putString("com.parse.Data", data.toString());
        }
        Intent intent = new Intent("com.parse.push.intent.RECEIVE");
        intent.putExtras(extras);
        Context context = Parse.getApplicationContext();
        intent.setPackage(context.getPackageName());
        context.sendBroadcast(intent);
        return true;
    }
}

