/*
 * Decompiled with CFR 0.152.
 */
package com.parse.http;

import com.parse.http.ParseHttpBody;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ParseHttpRequest {
    private final String url;
    private final Method method;
    private final Map<String, String> headers;
    private final ParseHttpBody body;

    private ParseHttpRequest(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.headers = Collections.unmodifiableMap(new HashMap(builder.headers));
        this.body = builder.body;
    }

    public String getUrl() {
        return this.url;
    }

    public Method getMethod() {
        return this.method;
    }

    public Map<String, String> getAllHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public ParseHttpBody getBody() {
        return this.body;
    }

    public static final class Builder {
        private String url;
        private Method method;
        private Map<String, String> headers;
        private ParseHttpBody body;

        public Builder() {
            this.headers = new HashMap<String, String>();
        }

        public Builder(ParseHttpRequest request) {
            this.url = request.url;
            this.method = request.method;
            this.headers = new HashMap<String, String>(request.headers);
            this.body = request.body;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setMethod(Method method) {
            this.method = method;
            return this;
        }

        public Builder setBody(ParseHttpBody body) {
            this.body = body;
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder addHeaders(Map<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = new HashMap<String, String>(headers);
            return this;
        }

        public ParseHttpRequest build() {
            return new ParseHttpRequest(this);
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;


        public static Method fromString(String string) {
            Method method;
            switch (string) {
                case "GET": {
                    method = GET;
                    break;
                }
                case "POST": {
                    method = POST;
                    break;
                }
                case "PUT": {
                    method = PUT;
                    break;
                }
                case "DELETE": {
                    method = DELETE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid http method: <" + string + ">");
                }
            }
            return method;
        }

        public String toString() {
            String string;
            switch (this) {
                case GET: {
                    string = "GET";
                    break;
                }
                case POST: {
                    string = "POST";
                    break;
                }
                case PUT: {
                    string = "PUT";
                    break;
                }
                case DELETE: {
                    string = "DELETE";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid http method: <" + (Object)((Object)this) + ">");
                }
            }
            return string;
        }
    }
}

