"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _invariant = require("invariant");

var _invariant2 = _interopRequireDefault(_invariant);

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var permissionsMap = { view: 0, edit: 7 };

exports.default = function (_ref) {
  var client = _ref.client,
      type = _ref.type;
  return function (folderid, userid, clientid) {
    var access = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "view";

    (0, _invariant2.default)(type === "pcloud", "This method supports only clients of type `pcloud`.");
    (0, _invariant2.default)(typeof folderid === "number", "`folderid` must be number.");
    (0, _invariant2.default)(folderid !== 0, "`folderid` cannot be 0.");
    (0, _invariant2.default)(["view", "edit"].indexOf(access) != -1, "`permissions` can be either `view` or `edit`.");

    (0, _invariant2.default)(userid, "`userid` is required.");
    (0, _invariant2.default)(typeof userid === "number", "`userid` is required.");
    (0, _invariant2.default)(parseInt(userid), "`userid` must be either number or a valid mail address.");
    (0, _invariant2.default)(clientid, "`clientid` is required");
    (0, _invariant2.default)(typeof clientid === "string", "`clientid` is required");

    return client.api("sharefolder", {
      params: {
        folderid: folderid,
        permissions: permissionsMap[access],
        userid: userid,
        client_id: clientid
      }
    }).then(function () {
      return true;
    });
  };
};