"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _invariant = require("invariant");

var _invariant2 = _interopRequireDefault(_invariant);

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var permissionsMap = { view: 0, edit: 7 };

exports.default = function (_ref) {
  var client = _ref.client;
  return function (folderid, mail) {
    var access = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "view";
    var message = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

    (0, _invariant2.default)(typeof folderid === "number", "`folderid` must be number.");
    (0, _invariant2.default)(folderid !== 0, "`folderid` cannot be 0.");
    (0, _invariant2.default)(["view", "edit"].indexOf(access) != -1, "`permissions` can be either `view` or `edit`.");

    (0, _invariant2.default)(mail, "`mail` is required.");
    (0, _invariant2.default)(typeof mail === "string", "`mail` is required.");
    (0, _invariant2.default)((0, _utils.isEmail)(mail), "`mail` must be either number or a valid mail address.");

    var params = {};
    params.folderid = folderid;
    params.permissions = permissionsMap[access];
    params.mail = mail;

    if (message) {
      params.message = message;
    }

    return client.api("sharefolder", {
      params: params
    }).then(function () {
      return true;
    });
  };
};