var ts = require('typescript');
function formatErrors(diags, logger) {
    diags.slice(0, 10)
        .forEach(function (diag) {
        if (diag.file) {
            var position = diag.file.getLineAndCharacterOfPosition(diag.start);
            var filename = diag.file.fileName;
            var locationText = filename + ":" + (position.line + 1) + ":" + (position.character + 1);
            if (diag.category === ts.DiagnosticCategory.Error)
                logger.error(locationText);
            else
                logger.warn(locationText);
        }
        var messageText = ts.flattenDiagnosticMessageText(diag.messageText, "\n");
        messageText = messageText + " (TS" + diag.code + ")";
        if (diag.category === ts.DiagnosticCategory.Error)
            logger.error(messageText);
        else
            logger.warn(messageText);
    });
}
exports.formatErrors = formatErrors;
//# sourceMappingURL=data:application/json;base64,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