/* */ 
var ts = require('typescript');
var logger_1 = require('./logger');
var compiler_host_1 = require('./compiler-host');
var transpiler_1 = require('./transpiler');
var type_checker_1 = require('./type-checker');
var format_errors_1 = require('./format-errors');
var utils_1 = require("./utils");
var logger = new logger_1.default({ debug: false });
function createFactory(sjsconfig, _resolve, _fetch) {
    if (sjsconfig === void 0) { sjsconfig = {}; }
    var tsconfigFiles = [];
    var typingsFiles = [];
    return loadOptions(sjsconfig, _resolve, _fetch)
        .then(function (options) {
        return createServices(options, _resolve, _fetch);
    })
        .then(function (services) {
        if (services.options.typeCheck) {
            return resolveDeclarationFiles(services.options, _resolve)
                .then(function (resolvedFiles) {
                resolvedFiles.forEach(function (resolvedFile) {
                    services.typeChecker.registerDeclarationFile(resolvedFile, false);
                });
                return services;
            });
        }
        else {
            return services;
        }
    });
}
exports.createFactory = createFactory;
function loadOptions(sjsconfig, _resolve, _fetch) {
    if (sjsconfig.tsconfig) {
        var tsconfig = (sjsconfig.tsconfig === true) ? "tsconfig.json" : sjsconfig.tsconfig;
        return _resolve(tsconfig)
            .then(function (tsconfigAddress) {
            return _fetch(tsconfigAddress).then(function (tsconfigText) { return ({ tsconfigText: tsconfigText, tsconfigAddress: tsconfigAddress }); });
        })
            .then(function (_a) {
            var tsconfigAddress = _a.tsconfigAddress, tsconfigText = _a.tsconfigText;
            var ts1 = ts;
            var result = ts1.parseConfigFileText ?
                ts1.parseConfigFileText(tsconfigAddress, tsconfigText) :
                ts1.parseConfigFileTextToJson(tsconfigAddress, tsconfigText);
            if (result.error) {
                format_errors_1.formatErrors([result.error], logger);
                throw new Error("failed to load tsconfig from " + tsconfigAddress);
            }
            var files = result.config.files;
            return ts.extend(ts.extend({ tsconfigAddress: tsconfigAddress, files: files }, sjsconfig), result.config.compilerOptions);
        });
    }
    else {
        return Promise.resolve(sjsconfig);
    }
}
function resolveDeclarationFiles(options, _resolve) {
    var files = options.files || [];
    var declarationFiles = files
        .filter(function (filename) { return utils_1.isTypescriptDeclaration(filename); })
        .map(function (filename) { return _resolve(filename, options.tsconfigAddress); });
    return Promise.all(declarationFiles);
}
function createServices(options, _resolve, _fetch) {
    var host = new compiler_host_1.CompilerHost(options);
    var transpiler = new transpiler_1.Transpiler(host);
    var typeChecker = undefined;
    if (options.typeCheck) {
        typeChecker = new type_checker_1.TypeChecker(host, _resolve, _fetch);
        if (!host.options.noLib) {
            return _resolve('ts', '')
                .then(function (moduleName) {
                return _resolve(host.getDefaultLibFileName(), moduleName);
            })
                .then(function (defaultLibAddress) {
                typeChecker.registerDeclarationFile(defaultLibAddress, true);
                return { transpiler: transpiler, typeChecker: typeChecker, host: host, options: options };
            });
        }
    }
    return Promise.resolve({ transpiler: transpiler, typeChecker: typeChecker, host: host, options: options });
}
//# sourceMappingURL=data:application/json;base64,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