/* */ 
"format cjs";
import { ListWrapper } from 'angular2/src/facade/collection';
import { isPresent } from 'angular2/src/facade/lang';
import { reflector } from 'angular2/src/core/reflection/reflection';
import { DirectiveIndex, BindingRecord, DirectiveRecord, ChangeDetectionStrategy, ChangeDetectorDefinition } from 'angular2/src/core/change_detection/change_detection';
import { PropertyBindingType, templateVisitAll } from './template_ast';
import { LifecycleHooks } from 'angular2/src/core/linker/interfaces';
export function createChangeDetectorDefinitions(componentType, componentStrategy, genConfig, parsedTemplate) {
    var pvVisitors = [];
    var visitor = new ProtoViewVisitor(null, pvVisitors, componentStrategy);
    templateVisitAll(visitor, parsedTemplate);
    return createChangeDefinitions(pvVisitors, componentType, genConfig);
}
class ProtoViewVisitor {
    constructor(parent, allVisitors, strategy) {
        this.parent = parent;
        this.allVisitors = allVisitors;
        this.strategy = strategy;
        this.boundTextCount = 0;
        this.boundElementCount = 0;
        this.variableNames = [];
        this.bindingRecords = [];
        this.eventRecords = [];
        this.directiveRecords = [];
        this.viewIndex = allVisitors.length;
        allVisitors.push(this);
    }
    visitEmbeddedTemplate(ast, context) {
        this.boundElementCount++;
        templateVisitAll(this, ast.outputs);
        for (var i = 0; i < ast.directives.length; i++) {
            ast.directives[i].visit(this, i);
        }
        var childVisitor = new ProtoViewVisitor(this, this.allVisitors, ChangeDetectionStrategy.Default);
        // Attention: variables present on an embedded template count towards
        // the embedded template and not the template anchor!
        templateVisitAll(childVisitor, ast.vars);
        templateVisitAll(childVisitor, ast.children);
        return null;
    }
    visitElement(ast, context) {
        if (ast.isBound()) {
            this.boundElementCount++;
        }
        templateVisitAll(this, ast.inputs, null);
        templateVisitAll(this, ast.outputs);
        templateVisitAll(this, ast.exportAsVars);
        for (var i = 0; i < ast.directives.length; i++) {
            ast.directives[i].visit(this, i);
        }
        templateVisitAll(this, ast.children);
        return null;
    }
    visitNgContent(ast, context) { return null; }
    visitVariable(ast, context) {
        this.variableNames.push(ast.name);
        return null;
    }
    visitEvent(ast, directiveRecord) {
        var bindingRecord = isPresent(directiveRecord) ?
            BindingRecord.createForHostEvent(ast.handler, ast.fullName, directiveRecord) :
            BindingRecord.createForEvent(ast.handler, ast.fullName, this.boundElementCount - 1);
        this.eventRecords.push(bindingRecord);
        return null;
    }
    visitElementProperty(ast, directiveRecord) {
        var boundElementIndex = this.boundElementCount - 1;
        var dirIndex = isPresent(directiveRecord) ? directiveRecord.directiveIndex : null;
        var bindingRecord;
        if (ast.type === PropertyBindingType.Property) {
            bindingRecord =
                isPresent(dirIndex) ?
                    BindingRecord.createForHostProperty(dirIndex, ast.value, ast.name) :
                    BindingRecord.createForElementProperty(ast.value, boundElementIndex, ast.name);
        }
        else if (ast.type === PropertyBindingType.Attribute) {
            bindingRecord =
                isPresent(dirIndex) ?
                    BindingRecord.createForHostAttribute(dirIndex, ast.value, ast.name) :
                    BindingRecord.createForElementAttribute(ast.value, boundElementIndex, ast.name);
        }
        else if (ast.type === PropertyBindingType.Class) {
            bindingRecord =
                isPresent(dirIndex) ?
                    BindingRecord.createForHostClass(dirIndex, ast.value, ast.name) :
                    BindingRecord.createForElementClass(ast.value, boundElementIndex, ast.name);
        }
        else if (ast.type === PropertyBindingType.Style) {
            bindingRecord =
                isPresent(dirIndex) ?
                    BindingRecord.createForHostStyle(dirIndex, ast.value, ast.name, ast.unit) :
                    BindingRecord.createForElementStyle(ast.value, boundElementIndex, ast.name, ast.unit);
        }
        this.bindingRecords.push(bindingRecord);
        return null;
    }
    visitAttr(ast, context) { return null; }
    visitBoundText(ast, context) {
        var boundTextIndex = this.boundTextCount++;
        this.bindingRecords.push(BindingRecord.createForTextNode(ast.value, boundTextIndex));
        return null;
    }
    visitText(ast, context) { return null; }
    visitDirective(ast, directiveIndexAsNumber) {
        var directiveIndex = new DirectiveIndex(this.boundElementCount - 1, directiveIndexAsNumber);
        var directiveMetadata = ast.directive;
        var directiveRecord = new DirectiveRecord({
            directiveIndex: directiveIndex,
            callAfterContentInit: directiveMetadata.lifecycleHooks.indexOf(LifecycleHooks.AfterContentInit) !== -1,
            callAfterContentChecked: directiveMetadata.lifecycleHooks.indexOf(LifecycleHooks.AfterContentChecked) !== -1,
            callAfterViewInit: directiveMetadata.lifecycleHooks.indexOf(LifecycleHooks.AfterViewInit) !== -1,
            callAfterViewChecked: directiveMetadata.lifecycleHooks.indexOf(LifecycleHooks.AfterViewChecked) !== -1,
            callOnChanges: directiveMetadata.lifecycleHooks.indexOf(LifecycleHooks.OnChanges) !== -1,
            callDoCheck: directiveMetadata.lifecycleHooks.indexOf(LifecycleHooks.DoCheck) !== -1,
            callOnInit: directiveMetadata.lifecycleHooks.indexOf(LifecycleHooks.OnInit) !== -1,
            changeDetection: directiveMetadata.changeDetection
        });
        this.directiveRecords.push(directiveRecord);
        templateVisitAll(this, ast.inputs, directiveRecord);
        var bindingRecords = this.bindingRecords;
        if (directiveRecord.callOnChanges) {
            bindingRecords.push(BindingRecord.createDirectiveOnChanges(directiveRecord));
        }
        if (directiveRecord.callOnInit) {
            bindingRecords.push(BindingRecord.createDirectiveOnInit(directiveRecord));
        }
        if (directiveRecord.callDoCheck) {
            bindingRecords.push(BindingRecord.createDirectiveDoCheck(directiveRecord));
        }
        templateVisitAll(this, ast.hostProperties, directiveRecord);
        templateVisitAll(this, ast.hostEvents, directiveRecord);
        templateVisitAll(this, ast.exportAsVars);
        return null;
    }
    visitDirectiveProperty(ast, directiveRecord) {
        // TODO: these setters should eventually be created by change detection, to make
        // it monomorphic!
        var setter = reflector.setter(ast.directiveName);
        this.bindingRecords.push(BindingRecord.createForDirective(ast.value, ast.directiveName, setter, directiveRecord));
        return null;
    }
}
function createChangeDefinitions(pvVisitors, componentType, genConfig) {
    var pvVariableNames = _collectNestedProtoViewsVariableNames(pvVisitors);
    return pvVisitors.map(pvVisitor => {
        var id = `${componentType.name}_${pvVisitor.viewIndex}`;
        return new ChangeDetectorDefinition(id, pvVisitor.strategy, pvVariableNames[pvVisitor.viewIndex], pvVisitor.bindingRecords, pvVisitor.eventRecords, pvVisitor.directiveRecords, genConfig);
    });
}
function _collectNestedProtoViewsVariableNames(pvVisitors) {
    var nestedPvVariableNames = ListWrapper.createFixedSize(pvVisitors.length);
    pvVisitors.forEach((pv) => {
        var parentVariableNames = isPresent(pv.parent) ? nestedPvVariableNames[pv.parent.viewIndex] : [];
        nestedPvVariableNames[pv.viewIndex] = parentVariableNames.concat(pv.variableNames);
    });
    return nestedPvVariableNames;
}
//# sourceMappingURL=data:application/json;base64,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