/* */ 
"format cjs";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { isPresent, isBlank, isString, StringWrapper, IS_DART } from 'angular2/src/facade/lang';
import { SetWrapper, StringMapWrapper, ListWrapper } from 'angular2/src/facade/collection';
import { TextCmd, NgContentCmd, BeginElementCmd, EndElementCmd, BeginComponentCmd, EndComponentCmd, EmbeddedTemplateCmd } from 'angular2/src/core/linker/template_commands';
import { templateVisitAll } from './template_ast';
import { SourceExpression, moduleRef } from './source_module';
import { escapeSingleQuoteString, codeGenConstConstructorCall, MODULE_SUFFIX } from './util';
import { Injectable } from 'angular2/src/core/di';
export var TEMPLATE_COMMANDS_MODULE_REF = moduleRef(`package:angular2/src/core/linker/template_commands${MODULE_SUFFIX}`);
const IMPLICIT_TEMPLATE_VAR = '\$implicit';
const CLASS_ATTR = 'class';
const STYLE_ATTR = 'style';
export let CommandCompiler = class {
    compileComponentRuntime(component, template, changeDetectorFactories, componentTemplateFactory) {
        var visitor = new CommandBuilderVisitor(new RuntimeCommandFactory(component, componentTemplateFactory, changeDetectorFactories), 0);
        templateVisitAll(visitor, template);
        return visitor.result;
    }
    compileComponentCodeGen(component, template, changeDetectorFactoryExpressions, componentTemplateFactory) {
        var visitor = new CommandBuilderVisitor(new CodegenCommandFactory(component, componentTemplateFactory, changeDetectorFactoryExpressions), 0);
        templateVisitAll(visitor, template);
        return new SourceExpression([], codeGenArray(visitor.result));
    }
};
CommandCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [])
], CommandCompiler);
class RuntimeCommandFactory {
    constructor(component, componentTemplateFactory, changeDetectorFactories) {
        this.component = component;
        this.componentTemplateFactory = componentTemplateFactory;
        this.changeDetectorFactories = changeDetectorFactories;
    }
    _mapDirectives(directives) {
        return directives.map(directive => directive.type.runtime);
    }
    createText(value, isBound, ngContentIndex) {
        return new TextCmd(value, isBound, ngContentIndex);
    }
    createNgContent(index, ngContentIndex) {
        return new NgContentCmd(index, ngContentIndex);
    }
    createBeginElement(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, isBound, ngContentIndex) {
        return new BeginElementCmd(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, this._mapDirectives(directives), isBound, ngContentIndex);
    }
    createEndElement() { return new EndElementCmd(); }
    createBeginComponent(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, encapsulation, ngContentIndex) {
        var nestedTemplateAccessor = this.componentTemplateFactory(directives[0]);
        return new BeginComponentCmd(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, this._mapDirectives(directives), encapsulation, ngContentIndex, nestedTemplateAccessor);
    }
    createEndComponent() { return new EndComponentCmd(); }
    createEmbeddedTemplate(embeddedTemplateIndex, attrNameAndValues, variableNameAndValues, directives, isMerged, ngContentIndex, children) {
        return new EmbeddedTemplateCmd(attrNameAndValues, variableNameAndValues, this._mapDirectives(directives), isMerged, ngContentIndex, this.changeDetectorFactories[embeddedTemplateIndex], children);
    }
}
class CodegenCommandFactory {
    constructor(component, componentTemplateFactory, changeDetectorFactoryExpressions) {
        this.component = component;
        this.componentTemplateFactory = componentTemplateFactory;
        this.changeDetectorFactoryExpressions = changeDetectorFactoryExpressions;
    }
    createText(value, isBound, ngContentIndex) {
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'TextCmd')}(${escapeSingleQuoteString(value)}, ${isBound}, ${ngContentIndex})`);
    }
    createNgContent(index, ngContentIndex) {
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'NgContentCmd')}(${index}, ${ngContentIndex})`);
    }
    createBeginElement(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, isBound, ngContentIndex) {
        var attrsExpression = codeGenArray(attrNameAndValues);
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'BeginElementCmd')}(${escapeSingleQuoteString(name)}, ${attrsExpression}, ` +
            `${codeGenArray(eventTargetAndNames)}, ${codeGenArray(variableNameAndValues)}, ${codeGenDirectivesArray(directives)}, ${isBound}, ${ngContentIndex})`);
    }
    createEndElement() {
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'EndElementCmd')}()`);
    }
    createBeginComponent(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, encapsulation, ngContentIndex) {
        var attrsExpression = codeGenArray(attrNameAndValues);
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'BeginComponentCmd')}(${escapeSingleQuoteString(name)}, ${attrsExpression}, ` +
            `${codeGenArray(eventTargetAndNames)}, ${codeGenArray(variableNameAndValues)}, ${codeGenDirectivesArray(directives)}, ${codeGenViewEncapsulation(encapsulation)}, ${ngContentIndex}, ${this.componentTemplateFactory(directives[0])})`);
    }
    createEndComponent() {
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'EndComponentCmd')}()`);
    }
    createEmbeddedTemplate(embeddedTemplateIndex, attrNameAndValues, variableNameAndValues, directives, isMerged, ngContentIndex, children) {
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'EmbeddedTemplateCmd')}(${codeGenArray(attrNameAndValues)}, ${codeGenArray(variableNameAndValues)}, ` +
            `${codeGenDirectivesArray(directives)}, ${isMerged}, ${ngContentIndex}, ${this.changeDetectorFactoryExpressions[embeddedTemplateIndex]}, ${codeGenArray(children)})`);
    }
}
function visitAndReturnContext(visitor, asts, context) {
    templateVisitAll(visitor, asts, context);
    return context;
}
class CommandBuilderVisitor {
    constructor(commandFactory, embeddedTemplateIndex) {
        this.commandFactory = commandFactory;
        this.embeddedTemplateIndex = embeddedTemplateIndex;
        this.result = [];
        this.transitiveNgContentCount = 0;
    }
    _readAttrNameAndValues(directives, attrAsts) {
        var attrs = keyValueArrayToMap(visitAndReturnContext(this, attrAsts, []));
        directives.forEach(directiveMeta => {
            StringMapWrapper.forEach(directiveMeta.hostAttributes, (value, name) => {
                var prevValue = attrs[name];
                attrs[name] = isPresent(prevValue) ? mergeAttributeValue(name, prevValue, value) : value;
            });
        });
        return mapToKeyValueArray(attrs);
    }
    visitNgContent(ast, context) {
        this.transitiveNgContentCount++;
        this.result.push(this.commandFactory.createNgContent(ast.index, ast.ngContentIndex));
        return null;
    }
    visitEmbeddedTemplate(ast, context) {
        this.embeddedTemplateIndex++;
        var childVisitor = new CommandBuilderVisitor(this.commandFactory, this.embeddedTemplateIndex);
        templateVisitAll(childVisitor, ast.children);
        var isMerged = childVisitor.transitiveNgContentCount > 0;
        var variableNameAndValues = [];
        ast.vars.forEach((varAst) => {
            variableNameAndValues.push(varAst.name);
            variableNameAndValues.push(varAst.value.length > 0 ? varAst.value : IMPLICIT_TEMPLATE_VAR);
        });
        var directives = [];
        ListWrapper.forEachWithIndex(ast.directives, (directiveAst, index) => {
            directiveAst.visit(this, new DirectiveContext(index, [], [], directives));
        });
        this.result.push(this.commandFactory.createEmbeddedTemplate(this.embeddedTemplateIndex, this._readAttrNameAndValues(directives, ast.attrs), variableNameAndValues, directives, isMerged, ast.ngContentIndex, childVisitor.result));
        this.transitiveNgContentCount += childVisitor.transitiveNgContentCount;
        this.embeddedTemplateIndex = childVisitor.embeddedTemplateIndex;
        return null;
    }
    visitElement(ast, context) {
        var component = ast.getComponent();
        var eventTargetAndNames = visitAndReturnContext(this, ast.outputs, []);
        var variableNameAndValues = [];
        if (isBlank(component)) {
            ast.exportAsVars.forEach((varAst) => {
                variableNameAndValues.push(varAst.name);
                variableNameAndValues.push(null);
            });
        }
        var directives = [];
        ListWrapper.forEachWithIndex(ast.directives, (directiveAst, index) => {
            directiveAst.visit(this, new DirectiveContext(index, eventTargetAndNames, variableNameAndValues, directives));
        });
        eventTargetAndNames = removeKeyValueArrayDuplicates(eventTargetAndNames);
        var attrNameAndValues = this._readAttrNameAndValues(directives, ast.attrs);
        if (isPresent(component)) {
            this.result.push(this.commandFactory.createBeginComponent(ast.name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, component.template.encapsulation, ast.ngContentIndex));
            templateVisitAll(this, ast.children);
            this.result.push(this.commandFactory.createEndComponent());
        }
        else {
            this.result.push(this.commandFactory.createBeginElement(ast.name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, ast.isBound(), ast.ngContentIndex));
            templateVisitAll(this, ast.children);
            this.result.push(this.commandFactory.createEndElement());
        }
        return null;
    }
    visitVariable(ast, ctx) { return null; }
    visitAttr(ast, attrNameAndValues) {
        attrNameAndValues.push(ast.name);
        attrNameAndValues.push(ast.value);
        return null;
    }
    visitBoundText(ast, context) {
        this.result.push(this.commandFactory.createText(null, true, ast.ngContentIndex));
        return null;
    }
    visitText(ast, context) {
        this.result.push(this.commandFactory.createText(ast.value, false, ast.ngContentIndex));
        return null;
    }
    visitDirective(ast, ctx) {
        ctx.targetDirectives.push(ast.directive);
        templateVisitAll(this, ast.hostEvents, ctx.eventTargetAndNames);
        ast.exportAsVars.forEach(varAst => {
            ctx.targetVariableNameAndValues.push(varAst.name);
            ctx.targetVariableNameAndValues.push(ctx.index);
        });
        return null;
    }
    visitEvent(ast, eventTargetAndNames) {
        eventTargetAndNames.push(ast.target);
        eventTargetAndNames.push(ast.name);
        return null;
    }
    visitDirectiveProperty(ast, context) { return null; }
    visitElementProperty(ast, context) { return null; }
}
function removeKeyValueArrayDuplicates(keyValueArray) {
    var knownPairs = new Set();
    var resultKeyValueArray = [];
    for (var i = 0; i < keyValueArray.length; i += 2) {
        var key = keyValueArray[i];
        var value = keyValueArray[i + 1];
        var pairId = `${key}:${value}`;
        if (!SetWrapper.has(knownPairs, pairId)) {
            resultKeyValueArray.push(key);
            resultKeyValueArray.push(value);
            knownPairs.add(pairId);
        }
    }
    return resultKeyValueArray;
}
function keyValueArrayToMap(keyValueArr) {
    var data = {};
    for (var i = 0; i < keyValueArr.length; i += 2) {
        data[keyValueArr[i]] = keyValueArr[i + 1];
    }
    return data;
}
function mapToKeyValueArray(data) {
    var entryArray = [];
    StringMapWrapper.forEach(data, (value, name) => { entryArray.push([name, value]); });
    // We need to sort to get a defined output order
    // for tests and for caching generated artifacts...
    ListWrapper.sort(entryArray, (entry1, entry2) => StringWrapper.compare(entry1[0], entry2[0]));
    var keyValueArray = [];
    entryArray.forEach((entry) => {
        keyValueArray.push(entry[0]);
        keyValueArray.push(entry[1]);
    });
    return keyValueArray;
}
function mergeAttributeValue(attrName, attrValue1, attrValue2) {
    if (attrName == CLASS_ATTR || attrName == STYLE_ATTR) {
        return `${attrValue1} ${attrValue2}`;
    }
    else {
        return attrValue2;
    }
}
class DirectiveContext {
    constructor(index, eventTargetAndNames, targetVariableNameAndValues, targetDirectives) {
        this.index = index;
        this.eventTargetAndNames = eventTargetAndNames;
        this.targetVariableNameAndValues = targetVariableNameAndValues;
        this.targetDirectives = targetDirectives;
    }
}
class Expression {
    constructor(value) {
        this.value = value;
    }
}
function escapeValue(value) {
    if (value instanceof Expression) {
        return value.value;
    }
    else if (isString(value)) {
        return escapeSingleQuoteString(value);
    }
    else if (isBlank(value)) {
        return 'null';
    }
    else {
        return `${value}`;
    }
}
function codeGenArray(data) {
    var base = `[${data.map(escapeValue).join(',')}]`;
    return IS_DART ? `const ${base}` : base;
}
function codeGenDirectivesArray(directives) {
    var expressions = directives.map(directiveType => `${moduleRef(directiveType.type.moduleUrl)}${directiveType.type.name}`);
    var base = `[${expressions.join(',')}]`;
    return IS_DART ? `const ${base}` : base;
}
function codeGenViewEncapsulation(value) {
    if (IS_DART) {
        return `${TEMPLATE_COMMANDS_MODULE_REF}${value}`;
    }
    else {
        return `${value}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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