/* */ 
"format cjs";
import { StringWrapper, isBlank } from 'angular2/src/facade/lang';
var MODULE_REGEXP = /#MODULE\[([^\]]*)\]/g;
export function moduleRef(moduleUrl) {
    return `#MODULE[${moduleUrl}]`;
}
/**
 * Represents generated source code with module references. Internal to the Angular compiler.
 */
export class SourceModule {
    constructor(moduleUrl, sourceWithModuleRefs) {
        this.moduleUrl = moduleUrl;
        this.sourceWithModuleRefs = sourceWithModuleRefs;
    }
    getSourceWithImports() {
        var moduleAliases = {};
        var imports = [];
        var newSource = StringWrapper.replaceAllMapped(this.sourceWithModuleRefs, MODULE_REGEXP, (match) => {
            var moduleUrl = match[1];
            var alias = moduleAliases[moduleUrl];
            if (isBlank(alias)) {
                if (moduleUrl == this.moduleUrl) {
                    alias = '';
                }
                else {
                    alias = `import${imports.length}`;
                    imports.push([moduleUrl, alias]);
                }
                moduleAliases[moduleUrl] = alias;
            }
            return alias.length > 0 ? `${alias}.` : '';
        });
        return new SourceWithImports(newSource, imports);
    }
}
export class SourceExpression {
    constructor(declarations, expression) {
        this.declarations = declarations;
        this.expression = expression;
    }
}
export class SourceExpressions {
    constructor(declarations, expressions) {
        this.declarations = declarations;
        this.expressions = expressions;
    }
}
/**
 * Represents generated source code with imports. Internal to the Angular compiler.
 */
export class SourceWithImports {
    constructor(source, imports) {
        this.source = source;
        this.imports = imports;
    }
}
//# sourceMappingURL=data:application/json;base64,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