/* */ 
"format cjs";
import { CONST_EXPR } from 'angular2/src/facade/lang';
import { Provider } from 'angular2/src/core/di';
import { APP_ID_RANDOM_PROVIDER } from './application_tokens';
import { IterableDiffers, defaultIterableDiffers, KeyValueDiffers, defaultKeyValueDiffers } from './change_detection/change_detection';
import { AppViewPool, APP_VIEW_POOL_CAPACITY } from './linker/view_pool';
import { AppViewManager } from './linker/view_manager';
import { AppViewManager_ } from "./linker/view_manager";
import { AppViewManagerUtils } from './linker/view_manager_utils';
import { ViewResolver } from './linker/view_resolver';
import { AppViewListener } from './linker/view_listener';
import { ProtoViewFactory } from './linker/proto_view_factory';
import { DirectiveResolver } from './linker/directive_resolver';
import { PipeResolver } from './linker/pipe_resolver';
import { Compiler } from './linker/compiler';
import { Compiler_ } from "./linker/compiler";
import { DynamicComponentLoader } from './linker/dynamic_component_loader';
import { DynamicComponentLoader_ } from "./linker/dynamic_component_loader";
/**
 * A default set of providers which should be included in any Angular
 * application, regardless of the platform it runs onto.
 */
export const APPLICATION_COMMON_PROVIDERS = CONST_EXPR([
    new Provider(Compiler, { useClass: Compiler_ }),
    APP_ID_RANDOM_PROVIDER,
    AppViewPool,
    new Provider(APP_VIEW_POOL_CAPACITY, { useValue: 10000 }),
    new Provider(AppViewManager, { useClass: AppViewManager_ }),
    AppViewManagerUtils,
    AppViewListener,
    ProtoViewFactory,
    ViewResolver,
    new Provider(IterableDiffers, { useValue: defaultIterableDiffers }),
    new Provider(KeyValueDiffers, { useValue: defaultKeyValueDiffers }),
    DirectiveResolver,
    PipeResolver,
    new Provider(DynamicComponentLoader, { useClass: DynamicComponentLoader_ })
]);
//# sourceMappingURL=data:application/json;base64,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