/* */ 
"format cjs";
import { IterableDiffers } from './differs/iterable_differs';
import { DefaultIterableDifferFactory } from './differs/default_iterable_differ';
import { KeyValueDiffers } from './differs/keyvalue_differs';
import { DefaultKeyValueDifferFactory } from './differs/default_keyvalue_differ';
import { CONST_EXPR } from 'angular2/src/facade/lang';
export { ASTWithSource, AST, AstTransformer, PropertyRead, LiteralArray, ImplicitReceiver } from './parser/ast';
export { Lexer } from './parser/lexer';
export { Parser } from './parser/parser';
export { Locals } from './parser/locals';
export { DehydratedException, ExpressionChangedAfterItHasBeenCheckedException, ChangeDetectionError } from './exceptions';
export { ChangeDetectorDefinition, DebugContext, ChangeDetectorGenConfig } from './interfaces';
export { ChangeDetectionStrategy, CHANGE_DETECTION_STRATEGY_VALUES } from './constants';
export { DynamicProtoChangeDetector } from './proto_change_detector';
export { JitProtoChangeDetector } from './jit_proto_change_detector';
export { BindingRecord, BindingTarget } from './binding_record';
export { DirectiveIndex, DirectiveRecord } from './directive_record';
export { DynamicChangeDetector } from './dynamic_change_detector';
export { ChangeDetectorRef } from './change_detector_ref';
export { IterableDiffers } from './differs/iterable_differs';
export { KeyValueDiffers } from './differs/keyvalue_differs';
export { WrappedValue, SimpleChange } from './change_detection_util';
/**
 * Structural diffing for `Object`s and `Map`s.
 */
export const keyValDiff = CONST_EXPR([CONST_EXPR(new DefaultKeyValueDifferFactory())]);
/**
 * Structural diffing for `Iterable` types such as `Array`s.
 */
export const iterableDiff = CONST_EXPR([CONST_EXPR(new DefaultIterableDifferFactory())]);
export const defaultIterableDiffers = CONST_EXPR(new IterableDiffers(iterableDiff));
export const defaultKeyValueDiffers = CONST_EXPR(new KeyValueDiffers(keyValDiff));
//# sourceMappingURL=data:application/json;base64,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