/* */ 
"format cjs";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { MapWrapper, StringMapWrapper } from 'angular2/src/facade/collection';
import { stringify, looseIdentical, isJsObject, CONST, isBlank } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
export let DefaultKeyValueDifferFactory = class {
    supports(obj) { return obj instanceof Map || isJsObject(obj); }
    create(cdRef) { return new DefaultKeyValueDiffer(); }
};
DefaultKeyValueDifferFactory = __decorate([
    CONST(), 
    __metadata('design:paramtypes', [])
], DefaultKeyValueDifferFactory);
export class DefaultKeyValueDiffer {
    constructor() {
        this._records = new Map();
        this._mapHead = null;
        this._previousMapHead = null;
        this._changesHead = null;
        this._changesTail = null;
        this._additionsHead = null;
        this._additionsTail = null;
        this._removalsHead = null;
        this._removalsTail = null;
    }
    get isDirty() {
        return this._additionsHead !== null || this._changesHead !== null ||
            this._removalsHead !== null;
    }
    forEachItem(fn) {
        var record;
        for (record = this._mapHead; record !== null; record = record._next) {
            fn(record);
        }
    }
    forEachPreviousItem(fn) {
        var record;
        for (record = this._previousMapHead; record !== null; record = record._nextPrevious) {
            fn(record);
        }
    }
    forEachChangedItem(fn) {
        var record;
        for (record = this._changesHead; record !== null; record = record._nextChanged) {
            fn(record);
        }
    }
    forEachAddedItem(fn) {
        var record;
        for (record = this._additionsHead; record !== null; record = record._nextAdded) {
            fn(record);
        }
    }
    forEachRemovedItem(fn) {
        var record;
        for (record = this._removalsHead; record !== null; record = record._nextRemoved) {
            fn(record);
        }
    }
    diff(map) {
        if (isBlank(map))
            map = MapWrapper.createFromPairs([]);
        if (!(map instanceof Map || isJsObject(map))) {
            throw new BaseException(`Error trying to diff '${map}'`);
        }
        if (this.check(map)) {
            return this;
        }
        else {
            return null;
        }
    }
    onDestroy() { }
    check(map) {
        this._reset();
        var records = this._records;
        var oldSeqRecord = this._mapHead;
        var lastOldSeqRecord = null;
        var lastNewSeqRecord = null;
        var seqChanged = false;
        this._forEach(map, (value, key) => {
            var newSeqRecord;
            if (oldSeqRecord !== null && key === oldSeqRecord.key) {
                newSeqRecord = oldSeqRecord;
                if (!looseIdentical(value, oldSeqRecord.currentValue)) {
                    oldSeqRecord.previousValue = oldSeqRecord.currentValue;
                    oldSeqRecord.currentValue = value;
                    this._addToChanges(oldSeqRecord);
                }
            }
            else {
                seqChanged = true;
                if (oldSeqRecord !== null) {
                    oldSeqRecord._next = null;
                    this._removeFromSeq(lastOldSeqRecord, oldSeqRecord);
                    this._addToRemovals(oldSeqRecord);
                }
                if (records.has(key)) {
                    newSeqRecord = records.get(key);
                }
                else {
                    newSeqRecord = new KVChangeRecord(key);
                    records.set(key, newSeqRecord);
                    newSeqRecord.currentValue = value;
                    this._addToAdditions(newSeqRecord);
                }
            }
            if (seqChanged) {
                if (this._isInRemovals(newSeqRecord)) {
                    this._removeFromRemovals(newSeqRecord);
                }
                if (lastNewSeqRecord == null) {
                    this._mapHead = newSeqRecord;
                }
                else {
                    lastNewSeqRecord._next = newSeqRecord;
                }
            }
            lastOldSeqRecord = oldSeqRecord;
            lastNewSeqRecord = newSeqRecord;
            oldSeqRecord = oldSeqRecord === null ? null : oldSeqRecord._next;
        });
        this._truncate(lastOldSeqRecord, oldSeqRecord);
        return this.isDirty;
    }
    /** @internal */
    _reset() {
        if (this.isDirty) {
            var record;
            // Record the state of the mapping
            for (record = this._previousMapHead = this._mapHead; record !== null; record = record._next) {
                record._nextPrevious = record._next;
            }
            for (record = this._changesHead; record !== null; record = record._nextChanged) {
                record.previousValue = record.currentValue;
            }
            for (record = this._additionsHead; record != null; record = record._nextAdded) {
                record.previousValue = record.currentValue;
            }
            // todo(vicb) once assert is supported
            // assert(() {
            //  var r = _changesHead;
            //  while (r != null) {
            //    var nextRecord = r._nextChanged;
            //    r._nextChanged = null;
            //    r = nextRecord;
            //  }
            //
            //  r = _additionsHead;
            //  while (r != null) {
            //    var nextRecord = r._nextAdded;
            //    r._nextAdded = null;
            //    r = nextRecord;
            //  }
            //
            //  r = _removalsHead;
            //  while (r != null) {
            //    var nextRecord = r._nextRemoved;
            //    r._nextRemoved = null;
            //    r = nextRecord;
            //  }
            //
            //  return true;
            //});
            this._changesHead = this._changesTail = null;
            this._additionsHead = this._additionsTail = null;
            this._removalsHead = this._removalsTail = null;
        }
    }
    /** @internal */
    _truncate(lastRecord, record) {
        while (record !== null) {
            if (lastRecord === null) {
                this._mapHead = null;
            }
            else {
                lastRecord._next = null;
            }
            var nextRecord = record._next;
            // todo(vicb) assert
            // assert((() {
            //  record._next = null;
            //  return true;
            //}));
            this._addToRemovals(record);
            lastRecord = record;
            record = nextRecord;
        }
        for (var rec = this._removalsHead; rec !== null; rec = rec._nextRemoved) {
            rec.previousValue = rec.currentValue;
            rec.currentValue = null;
            this._records.delete(rec.key);
        }
    }
    /** @internal */
    _isInRemovals(record) {
        return record === this._removalsHead || record._nextRemoved !== null ||
            record._prevRemoved !== null;
    }
    /** @internal */
    _addToRemovals(record) {
        // todo(vicb) assert
        // assert(record._next == null);
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        // assert(record._nextRemoved == null);
        // assert(record._prevRemoved == null);
        if (this._removalsHead === null) {
            this._removalsHead = this._removalsTail = record;
        }
        else {
            this._removalsTail._nextRemoved = record;
            record._prevRemoved = this._removalsTail;
            this._removalsTail = record;
        }
    }
    /** @internal */
    _removeFromSeq(prev, record) {
        var next = record._next;
        if (prev === null) {
            this._mapHead = next;
        }
        else {
            prev._next = next;
        }
        // todo(vicb) assert
        // assert((() {
        //  record._next = null;
        //  return true;
        //})());
    }
    /** @internal */
    _removeFromRemovals(record) {
        // todo(vicb) assert
        // assert(record._next == null);
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        var prev = record._prevRemoved;
        var next = record._nextRemoved;
        if (prev === null) {
            this._removalsHead = next;
        }
        else {
            prev._nextRemoved = next;
        }
        if (next === null) {
            this._removalsTail = prev;
        }
        else {
            next._prevRemoved = prev;
        }
        record._prevRemoved = record._nextRemoved = null;
    }
    /** @internal */
    _addToAdditions(record) {
        // todo(vicb): assert
        // assert(record._next == null);
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        // assert(record._nextRemoved == null);
        // assert(record._prevRemoved == null);
        if (this._additionsHead === null) {
            this._additionsHead = this._additionsTail = record;
        }
        else {
            this._additionsTail._nextAdded = record;
            this._additionsTail = record;
        }
    }
    /** @internal */
    _addToChanges(record) {
        // todo(vicb) assert
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        // assert(record._nextRemoved == null);
        // assert(record._prevRemoved == null);
        if (this._changesHead === null) {
            this._changesHead = this._changesTail = record;
        }
        else {
            this._changesTail._nextChanged = record;
            this._changesTail = record;
        }
    }
    toString() {
        var items = [];
        var previous = [];
        var changes = [];
        var additions = [];
        var removals = [];
        var record;
        for (record = this._mapHead; record !== null; record = record._next) {
            items.push(stringify(record));
        }
        for (record = this._previousMapHead; record !== null; record = record._nextPrevious) {
            previous.push(stringify(record));
        }
        for (record = this._changesHead; record !== null; record = record._nextChanged) {
            changes.push(stringify(record));
        }
        for (record = this._additionsHead; record !== null; record = record._nextAdded) {
            additions.push(stringify(record));
        }
        for (record = this._removalsHead; record !== null; record = record._nextRemoved) {
            removals.push(stringify(record));
        }
        return "map: " + items.join(', ') + "\n" + "previous: " + previous.join(', ') + "\n" +
            "additions: " + additions.join(', ') + "\n" + "changes: " + changes.join(', ') + "\n" +
            "removals: " + removals.join(', ') + "\n";
    }
    /** @internal */
    _forEach(obj, fn) {
        if (obj instanceof Map) {
            obj.forEach(fn);
        }
        else {
            StringMapWrapper.forEach(obj, fn);
        }
    }
}
export class KVChangeRecord {
    constructor(key) {
        this.key = key;
        this.previousValue = null;
        this.currentValue = null;
        /** @internal */
        this._nextPrevious = null;
        /** @internal */
        this._next = null;
        /** @internal */
        this._nextAdded = null;
        /** @internal */
        this._nextRemoved = null;
        /** @internal */
        this._prevRemoved = null;
        /** @internal */
        this._nextChanged = null;
    }
    toString() {
        return looseIdentical(this.previousValue, this.currentValue) ?
            stringify(this.key) :
            (stringify(this.key) + '[' + stringify(this.previousValue) + '->' +
                stringify(this.currentValue) + ']');
    }
}
//# sourceMappingURL=data:application/json;base64,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